package com.paydevice.websocketserver;

import android.util.Log;

import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;


public class SmartPosSocketServer extends WebSocketServer {

	private static final String TAG = "SmartPosSocketServer";
	public SmartPosSocketServer(int port) throws UnknownHostException {
		super(new InetSocketAddress(port));
	}

	public SmartPosSocketServer(InetSocketAddress address) {
		super(address);
	}

	@Override
	public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
		String address = webSocket.getRemoteSocketAddress().getAddress().getHostAddress();
		String message = String.format("(%s) connected", address);
		Log.d(TAG,message);
	}

	@Override
	public void onClose(WebSocket webSocket, int i, String s, boolean b) {
		String message = String.format("(%s) disconnected", webSocket);
		Log.d(TAG,message);
	}

	@Override
	public void onMessage(WebSocket webSocket, String s) {
		String address = webSocket.getRemoteSocketAddress().getAddress().getHostAddress();
		String message = String.format("(%s) %s", address, s);
		if (mConnandListener != null) {
			mConnandListener.onCommands(s);
		}
		Log.d(TAG,message);
	}

	@Override
	public void onError(WebSocket webSocket, Exception e) {
		if (null != webSocket) {
			webSocket.close(0);
		}
		e.printStackTrace();
	}

	@Override
	public void onStart() {
		setConnectionLostTimeout(30);
	}

	private CommandListener mConnandListener;
	public interface CommandListener {
		void onCommands(String cmd);
	}
	public void setCommandListener(CommandListener l) {
		this.mConnandListener = l;
	}
}
