package com.paydevice.websocketserver;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.text.Layout;
import android.util.Log;

import com.paydevice.websocketserver.proxy.*;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class SmartPosProxyService extends Service
	implements SmartPosSocketServer.CommandListener {
	private final static String TAG = "SmartPosProxyService";

    private final MsgBinder mBinder = new MsgBinder();
	private SmartPosSocketServer spss;
	private static boolean running = false;

	PrinterProxy mPrinterProxy;

    public class MsgBinder extends Binder {
        public SmartPosProxyService getService() {
            return SmartPosProxyService.this;
        }
    }

	@Override
	public IBinder onBind(Intent intent) {
		return null;
	}

	@Override
	public void onCreate() {
		super.onCreate();
		final String id = "wssID";
		final String title = "WebSocketServer";
		Notification.Builder builder = new Notification.Builder(this)
			.setContentTitle(title);

		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
			NotificationManager nm = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
			NotificationChannel nc = new NotificationChannel(id, title, NotificationManager.IMPORTANCE_HIGH);
			nm.createNotificationChannel(nc);
			builder.setChannelId(id);
		}
		startForeground(1, builder.build());
	}

	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		if (!running) {
			Log.d(TAG,"first run");
			try {
				spss = new SmartPosSocketServer(9999);
				spss.setReuseAddr(true);
				spss.setCommandListener(this);
				running = true;
			} catch (UnknownHostException e) {
				e.printStackTrace();
			}
			spss.start();
		} else {
			Log.d(TAG,"alread running");
		}
		return super.onStartCommand(intent, flags, startId);
	}

	@Override
	public void onCommands(String data) {
		try {
			//Log.d(TAG,"data:"+data);
			final JSONObject json = new JSONObject(data);
			String dev = json.optString("dev");
			String cmd = json.optString("cmd");
			//Log.d(TAG,"dev:"+dev+" cmd:"+cmd);
			String[] args = null;
			try {
				JSONArray argsArray = json.getJSONArray("args");
				args = new String[argsArray.length()];
				for(int i=0;i<args.length;i++) {
					args[i] = argsArray.getString(i).replace("\"","");
					//Log.d(TAG,"args["+i+"]:"+args[i]);
				}
			} catch(JSONException je) {
				//Log.d(TAG,"no args");
			}
			JSONObject ack = new JSONObject();
			if (dev.equals("printer")) {
				if (mPrinterProxy == null) {
					mPrinterProxy = new PrinterProxy();
				}
				if (cmd.equals("connectBuiltinPrinter")) {
					ack.put("dev","printer");
					ack.put("cmd","connectBuiltinPrinter");
					if (mPrinterProxy.connectBuiltinPrinter(this, Integer.parseInt(args[0]))) {
						ack.put("ack","true");
					} else {
						ack.put("ack","false");
                    }
					spss.broadcast(ack.toString());
				} else if (cmd.equals("connectSerialPrinter")) {
					ack.put("dev","printer");
					ack.put("cmd","connectSerialPrinter");
					if (mPrinterProxy.connectSerialPrinter(this, args[0], Integer.parseInt(args[1]), Integer.parseInt(args[2]))) {
						ack.put("ack","true");
					} else {
						ack.put("ack","false");
                    }
					spss.broadcast(ack.toString());
				} else if (cmd.equals("connectUsbPrinter")) {
					ack.put("dev","printer");
					ack.put("cmd","connectUsbPrinter");
					if (mPrinterProxy.connectUsbPrinter(this, Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2]))) {
						ack.put("ack","true");
					} else {
						ack.put("ack","false");
                    }
					spss.broadcast(ack.toString());
				} else if (cmd.equals("disconnect")) {
					mPrinterProxy.disconnect();
				} else if (cmd.equals("checkPaper")) {
					ack.put("dev","printer");
					ack.put("cmd","checkPaper");
					if(mPrinterProxy.checkPaper()) {
						ack.put("ack","true");
					} else {
						ack.put("ack","false");
					}
					spss.broadcast(ack.toString());
				} else if (cmd.equals("setStringEncoding")) {
					mPrinterProxy.setStringEncoding(args[0]);
				} else if (cmd.equals("sendData")) {
					if (args != null && args.length > 1)
						mPrinterProxy.sendData(args[0],args[1]);
					else
						mPrinterProxy.sendData(args[0]);
				} else if (cmd.equals("cmdLineFeed")) {
					if (args == null || args.length == 0) {
						mPrinterProxy.cmdLineFeed();
                    } else {
                        if (args[0] == null || args[0].equals("null")) {
                            mPrinterProxy.cmdLineFeed();
                        } else {
                            mPrinterProxy.cmdLineFeed(Integer.parseInt(args[0]));
                        }
                    }
				} else if (cmd.equals("cmdSetDefaultLineSpacing")) {
					mPrinterProxy.cmdSetDefaultLineSpacing();
				} else if (cmd.equals("cmdSetLineSpacing")) {
					mPrinterProxy.cmdSetLineSpacing(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdSetAlignMode")) {
					mPrinterProxy.cmdSetAlignMode(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdSetPrintOffset")) {
					mPrinterProxy.cmdSetPrintOffset(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdSetPrintMode")) {
					mPrinterProxy.cmdSetPrintMode(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdSetUnderlineHeight")) {
					mPrinterProxy.cmdSetUnderlineHeight(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdSetFontScaleSize")) {
					mPrinterProxy.cmdSetFontScaleSize(Integer.parseInt(args[0]),Integer.parseInt(args[1]));
				} else if (cmd.equals("cmdSetBarCodeStringPosition")) {
					mPrinterProxy.cmdSetBarCodeStringPosition(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdSetBarCodeStringSize")) {
					mPrinterProxy.cmdSetBarCodeStringSize(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdSetBarCodeHeight")) {
					mPrinterProxy.cmdSetBarCodeHeight(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdSetBarCodeWidth")) {
					mPrinterProxy.cmdSetBarCodeWidth(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdSetBarCodeLeftSpacing")) {
					mPrinterProxy.cmdSetBarCodeLeftSpacing(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdBarCodePrint")) {
					mPrinterProxy.cmdBarCodePrint(Integer.parseInt(args[0]),args[1]);
				} else if (cmd.equals("cmdBitmapPrint")) {
					//NOTE:avoid bitmap scaled by lcd density
					BitmapFactory.Options options = new BitmapFactory.Options();
					options.inTargetDensity = 0;
					options.inScaled = false;//disable scaled, must be original size
					Bitmap bmp = BitmapFactory.decodeStream(new FileInputStream(Environment.getExternalStorageDirectory().getPath()+"/"+args[0]), null, options);
					mPrinterProxy.cmdBitmapPrint(bmp, Integer.parseInt(args[1]), Integer.parseInt(args[2]));
				} else if (cmd.equals("cmdBitmapPrintEx")) {
					//NOTE:avoid bitmap scaled by lcd density
					BitmapFactory.Options options = new BitmapFactory.Options();
					options.inTargetDensity = 0;
					options.inScaled = false;//disable scaled, must be original size
					Bitmap bmp = BitmapFactory.decodeStream(new FileInputStream(Environment.getExternalStorageDirectory().getPath()+"/"+args[0]), null, options);
					mPrinterProxy.cmdBitmapPrintEx(bmp, Integer.parseInt(args[1]), Integer.parseInt(args[2]));
				} else if (cmd.equals("cmdSetHeatingParam")) {
					mPrinterProxy.cmdSetHeatingParam(Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2]));
				} else if (cmd.equals("cmdSetPrintDensity")) {
					mPrinterProxy.cmdSetPrintDensity(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
				} else if (cmd.equals("cmdSetCharacterSet")) {
					mPrinterProxy.cmdSetCharacterSet(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdSetPrinterLanguage")) {
					mPrinterProxy.cmdSetPrinterLanguage(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdQrCodePrint")) {
					mPrinterProxy.cmdQrCodePrint(Integer.parseInt(args[0]), Integer.parseInt(args[1]), args[2]);
				} else if (cmd.equals("printDevidingLine")) {
					mPrinterProxy.printDevidingLine();
				} else if (cmd.equals("cmdPrintTest")) {
					mPrinterProxy.cmdPrintTest();
				} else if (cmd.equals("cmdJumpTab")) {
					mPrinterProxy.cmdJumpTab();
				} else if (cmd.equals("cmdSetTable")) {
					String[] array = args[0].split(",");
					byte[] offsets = new byte[array.length];
					for (int i=0;i<array.length;i++) {
						offsets[i] = (byte)Integer.parseInt(array[i]);
					}
					mPrinterProxy.cmdSetTable(offsets);
				} else if (cmd.equals("cmdUnSetTable")) {
					mPrinterProxy.cmdUnSetTable();
				} else if (cmd.equals("getPrinterType")) {
					ack.put("dev","printer");
					ack.put("cmd","getPrinterType");
					ack.put("ack",mPrinterProxy.getPrinterType());
					spss.broadcast(ack.toString());
				} else if (cmd.equals("cmdCutPaper")) {
					mPrinterProxy.cmdCutPaper(Integer.parseInt(args[0]));
				} else if (cmd.equals("cmdPrintBitmapFromNVRAM")) {
					mPrinterProxy.cmdPrintBitmapFromNVRAM(Integer.parseInt(args[0]),Integer.parseInt(args[1]));
				} else if (cmd.equals("isBuiltInSlow")) {
					ack.put("dev","printer");
					ack.put("cmd","isBuiltInSlow");
					if(mPrinterProxy.isBuiltInSlow()) {
						ack.put("ack","true");
					} else {
						ack.put("ack","false");
					}
					spss.broadcast(ack.toString());
				} else if (cmd.equals("printLine")) {
						mPrinterProxy.printLine(args[0]);
				} else if (cmd.equals("printLineCombo")) {
						mPrinterProxy.printLine(args[0], args[1]);
                } else if (cmd.equals("printLineMulti")) {
                    //String[] arrStr = args[0].replace("[","").replace("]","").replace("\"","").split(",");
                    String[] arrStr = args[0].replaceAll("\\[|\\]","").split(",");
                    String[] tmp1 = args[1].replace("[","").replace("]","").split(",");
                    String[] tmp2 = args[2].replace("[","").replace("]","").split(",");
                    int[] arrWidth = new int[tmp1.length];
                    int[] arrAlign = new int[tmp2.length];
                    for(int i=0;i<tmp1.length;i++){
                        arrWidth[i] = Integer.parseInt(tmp1[i]);
                        arrAlign[i] = Integer.parseInt(tmp2[i]);
                    }
                    mPrinterProxy.printLine(arrStr, arrWidth, arrAlign);
                } else if (cmd.equals("printLineByBitmap")) {
						mPrinterProxy.printLineByBitmap(args[0]);
				} else if (cmd.equals("printLineComboByBitmap")) {
						mPrinterProxy.printLineByBitmap(args[0], args[1]);
                } else if (cmd.equals("printLineMultiByBitmap")) {
                    String[] arrStr = args[0].replaceAll("\\[|\\]","").split(",");
                    String[] tmp1 = args[1].replace("[","").replace("]","").split(",");
                    String[] tmp2 = args[2].replace("[","").replace("]","").split(",");
                    int[] arrWidth = new int[tmp1.length];
                    int[] arrAlign = new int[tmp2.length];
                    for(int i=0;i<tmp1.length;i++){
                        arrWidth[i] = Integer.parseInt(tmp1[i]);
                        arrAlign[i] = Integer.parseInt(tmp2[i]);
                    }
                    mPrinterProxy.printLineByBitmap(arrStr, arrWidth, arrAlign);
                } else if (cmd.equals("saveBitmaptoNVRAM")) {
					int bmpCount = args.length;
					Bitmap[] arrays = new Bitmap[bmpCount];
					//NOTE:avoid bitmap scaled by lcd density
					BitmapFactory.Options options = new BitmapFactory.Options();
					options.inTargetDensity = 0;
					options.inScaled = false;//disable scaled, must be original size
					for(int i=0;i<bmpCount;i++) {
						arrays[i] = BitmapFactory.decodeStream(new FileInputStream(Environment.getExternalStorageDirectory().getPath()+"/"+args[i]), null, options);
					}
					Log.d(TAG,"bmp count:"+bmpCount);
					ack.put("dev","printer");
					ack.put("cmd","saveBitmaptoNVRAM");
					if(mPrinterProxy.saveBitmaptoNVRAM(arrays)) {
						ack.put("ack","true");
					} else {
						ack.put("ack","false");
					}
					spss.broadcast(ack.toString());
				} else if (cmd.equals("deleteBitmapFromNVRAM")) {
					ack.put("dev","printer");
					ack.put("cmd","deleteBitmapFromNVRAM");
					if(mPrinterProxy.deleteBitmapFromNVRAM()) {
						ack.put("ack","true");
					} else {
						ack.put("ack","false");
					}
					spss.broadcast(ack.toString());
				}
			} else if (dev.equals("cashdrawer")) {
				if (cmd.equals("open")) {
					CashDrawerProxy.open();
				} else if (cmd.equals("openEx")) {
					CashDrawerProxy.openEx();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
