package com.paydevice.websocketserver;

import android.Manifest;
import android.app.Service;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.IBinder;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "SmartPosSocketServer";
    private SmartPosProxyService mService = null;
    private ServiceConnection mConn = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            mService = ((SmartPosProxyService.MsgBinder) service).getService();
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    };


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        //bind service
        Intent intent = new Intent(this, SmartPosProxyService.class);
        startService(intent);
        bindService(intent, mConn, Service.BIND_AUTO_CREATE);
		//request read permission for logos
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			if (PackageManager.PERMISSION_DENIED == checkSelfPermission(Manifest.permission.READ_EXTERNAL_STORAGE)) {
				requestPermissions(new String[] {Manifest.permission.READ_EXTERNAL_STORAGE}, 0);
			}
		}
    }

	@Override
	public void onRequestPermissionsResult(int requestCode, String permissions[], int[] grantResults) {
	}

    @Override
    protected void onDestroy() {
        super.onDestroy();
		Log.d(TAG,"onDestroy");
		unbindService(mConn);
    }

    public void onBtnClick(View v) {
        Intent i = new Intent();
        i.setData(Uri.parse("https://paydevice.xyz/webdemo"));
        i.setAction(Intent.ACTION_VIEW);
        startActivity(i);
    }
}
