/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.samcard;

import com.paydevice.smartpos.sdk.DeviceNative;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SamCardManager {
    private static final String TAG = "SamCardManager";
    public static final int CARD_SEND_MAX_LEN = 8208;
    public static final int CARD_RESP_MAX_LEN = 8194;
    public static final int CARD_TYPE_T0 = 0;
    public static final int CARD_TYPE_T1 = 1;
    public static final int CARD_SLOT_1 = 1;
    public static final int CARD_SLOT_2 = 2;
    public static final int CARD_PARAMS_DEFAULT = 0;
    public static final int CARD_VOLTAGE_1V8 = 1;
    public static final int CARD_VOLTAGE_3V0 = 2;
    public static final int CARD_VOLTAGE_5V0 = 3;
    public static final int CARD_PPS_NOSUPPORT = 0;
    public static final int CARD_PPS_SUPPORT = 4;
    public static final int CARD_PPS_ENFORCE = 8;
    public static final int CARD_BPS_9600 = 0;
    public static final int CARD_BPS_19200 = 16;
    public static final int CARD_BPS_38400 = 32;
    public static final int CARD_EMV_SPEC = 0;
    public static final int CARD_ISO_SPEC = 64;
    public static final int CARD_NOCHECK_SPEC = 128;
    public static final int ERR_NODEV = -1000;
    public static final int ERR_PARAM = -1001;
    public static final int ERR_NOINIT = -1002;
    public static final int ERR_SLOT = -1003;
    public static final int ERR_WRITE = -1004;
    public static final int ERR_READ = -1005;
    public static final int ERR_OOM = -1006;
    public static final int ERR_RESPONSE = -1007;
    public static final int ERR_RESPONSE_SUM = -1008;
    public static final int ERR_CARD_DETECT = -1010;
    public static final int ERR_CARD_OPEN = -1011;
    public static final int ERR_CARD_EXCHANGE = -1012;
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Lock wlock = lock.writeLock();

    public int init() {
        int err = 0;
        wlock.lock();
        err = DeviceNative.nativeSamInit();
        wlock.unlock();
        return err;
    }

    public void deinit() {
        wlock.lock();
        DeviceNative.nativeSamDeinit();
        wlock.unlock();
    }

    public int cardOpen(int slot, int config, byte[] atr) {
        int err = 0;
        wlock.lock();
        err = DeviceNative.nativeSamCardOpen(slot, config, atr);
        wlock.unlock();
        return err;
    }

    public void cardClose(int slot) {
        wlock.lock();
        DeviceNative.nativeSamCardClose(slot);
        wlock.unlock();
    }

    public int cardDetect(int slot) {
        int err = 0;
        wlock.lock();
        err = DeviceNative.nativeSamCardDetect(slot);
        wlock.unlock();
        return err;
    }

    public int cardExchange(int slot, byte[] command, int cmdLen, byte[] response, int respLen, int timeoutMs) {
        int err = 0;
        wlock.lock();
        err = DeviceNative.nativeSamCardExchange(slot, command, cmdLen, response, respLen, timeoutMs);
        wlock.unlock();
        return err;
    }

    public void enableDebugLog(boolean enable) {
        DeviceNative.nativeSamDebubOn(enable);
    }

    static {
        try {
            System.loadLibrary("paydevice-smartpos");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

