/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.led;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class LedManager {
    private static final String RED_LED_IO = "/dev/led_red_io";
    private static final String GREEN_LED_IO = "/dev/led_green_io";
    private static final String BLUE_LED_IO = "/dev/led_blue_io";
    private static final String RED_LED = "sys/class/leds/red/brightness";
    private static final String GREEN_LED = "sys/class/leds/green/brightness";
    private static final String BLUE_LED = "sys/class/leds/blue/brightness";
    private static final String LED_ON = "1";
    private static final String LED_OFF = "0";

    public void setRedLed(boolean on) {
        File node = new File(RED_LED_IO);
        if (node.exists()) {
            this.write(RED_LED_IO, on ? LED_ON : LED_OFF);
        } else {
            this.write(RED_LED, on ? LED_ON : LED_OFF);
        }
    }

    public void setGreenLed(boolean on) {
        File node = new File(GREEN_LED_IO);
        if (node.exists()) {
            this.write(GREEN_LED_IO, on ? LED_ON : LED_OFF);
        } else {
            this.write(GREEN_LED, on ? LED_ON : LED_OFF);
        }
    }

    public void setBlueLed(boolean on) {
        File node = new File(BLUE_LED_IO);
        if (node.exists()) {
            this.write(BLUE_LED_IO, on ? LED_ON : LED_OFF);
        } else {
            this.write(BLUE_LED, on ? LED_ON : LED_OFF);
        }
    }

    private void write(String path, String value) {
        try {
            FileOutputStream fo = new FileOutputStream(path);
            fo.write(value.getBytes());
            fo.flush();
            fo.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

