/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.gpio;

import android.os.Build;
import com.paydevice.smartpos.sdk.DeviceNative;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Gpio {
    public static final int LEVEL_LOW = 0;
    public static final int LEVEL_HIGH = 1;
    public static final int MODE_INPUT = 0;
    public static final int MODE_OUTPUT = 1;
    private static Method init = null;
    private static Method deInit = null;
    private static Method setValue = null;
    private static Method setDirection = null;
    private static Method getValue = null;
    private static Object obj = null;

    public static void init(int gpio) {
        if (Build.VERSION.SDK_INT > 25) {
            DeviceNative.nativeGpioInit(gpio);
        } else {
            try {
                Class<?> gpioClass = Build.VERSION.SDK_INT > 22 ? Class.forName("android.hardware.Gpio") : Class.forName("com.android.Gpio");
                init = gpioClass.getMethod("init", Integer.TYPE);
                deInit = gpioClass.getMethod("deInit", Integer.TYPE);
                setValue = gpioClass.getMethod("setValue", Integer.TYPE, Integer.TYPE);
                getValue = gpioClass.getMethod("getValue", Integer.TYPE);
                setDirection = gpioClass.getMethod("setDirection", Integer.TYPE, Integer.TYPE);
                init.invoke(obj, gpio);
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    public static void setMode(int gpio, int mode) {
        if (Build.VERSION.SDK_INT > 25) {
            DeviceNative.nativeGpioSetMode(gpio, mode);
        } else if (setDirection != null) {
            try {
                setDirection.invoke(obj, gpio, mode);
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (IllegalArgumentException e3) {
                e3.printStackTrace();
            }
            catch (InvocationTargetException e4) {
                e4.printStackTrace();
            }
        }
    }

    public static int getValue(int gpio) {
        if (Build.VERSION.SDK_INT > 25) {
            return DeviceNative.nativeGpioGetValue(gpio);
        }
        if (getValue != null) {
            try {
                return (Integer)getValue.invoke(obj, gpio);
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (IllegalArgumentException e3) {
                e3.printStackTrace();
            }
            catch (InvocationTargetException e4) {
                e4.printStackTrace();
            }
        }
        return 0;
    }

    public static void setValue(int gpio, int value) {
        if (Build.VERSION.SDK_INT > 25) {
            DeviceNative.nativeGpioSetValue(gpio, value);
        } else if (setValue != null) {
            try {
                setValue.invoke(obj, gpio, value);
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (IllegalArgumentException e3) {
                e3.printStackTrace();
            }
            catch (InvocationTargetException e4) {
                e4.printStackTrace();
            }
        }
    }

    public static void deinit(int gpio) {
        if (Build.VERSION.SDK_INT > 25) {
            DeviceNative.nativeGpioDeInit(gpio);
        } else if (deInit != null) {
            try {
                deInit.invoke(obj, gpio);
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (IllegalArgumentException e3) {
                e3.printStackTrace();
            }
            catch (InvocationTargetException e4) {
                e4.printStackTrace();
            }
        }
    }
}

