
package com.paydevice.smartpos.demo.smartcard;

import android.annotation.SuppressLint;
import android.support.v7.app.AppCompatActivity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

import com.paydevice.smartpos.demo.R;
import com.paydevice.smartpos.demo.MyToast;
import com.paydevice.smartpos.demo.Utils;
import com.paydevice.smartpos.sdk.SmartPosException;
import com.paydevice.smartpos.sdk.smartcard.SmartCardManager;

public class SLE6636Activity extends AppCompatActivity {

    private static final String TAG = "SLE6636Activity";

    private static final String KEY_RESULT = "result";
    private static final String KEY_ERR_CODE = "code";

	private static final int MAX_WRITE_BYTE_LEN = 48;
	private static final int MAX_CHALLENGE_BYTE_LEN = 6;

    private static final int MSG_OPEN_RESULT = 1;
    private static final int MSG_CLOSE_RESULT = 2;
    private boolean mOpenFlag = false;
    
    private SmartCardManager mSmartCardManager;

	private MyToast mToast;
    private TextView mText;
    private TextView mEditMemAddr;
    private TextView mEditMemData;
    private TextView mEditMemLength;
    private TextView mEditCounterAddr;
    private TextView mEditCounterData;
    private TextView mEditReloadAddr;
    private TextView mEditAuthKey;
    private TextView mEditAuthClock;
    private TextView mEditAuthChallenge;
    private TextView mEditTc1;
    private TextView mEditTc2;
    private TextView mEditTc3;

	private ProgressDialog mWaitProgress; 

    private Button mOpenBtn;
    private Button mCloseBtn;
    private Button mWriteMemBtn;
    private Button mReadMemBtn;
    private Button mWriteCounterBtn;
    private Button mReadCounterBtn;
    private Button mReloadBtn;
    private Button mAuthBtn;
    private Button mVerifyBtn;

    private OpenTask mOpenTask;
    private CloseTask mCloseTask;

    private Builder mSlotDialog;
    private int mSlotSelected = 0;
    private int mSlotCount = 1;

    @SuppressLint("HandlerLeak")
    public Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            Boolean result = msg.getData().getBoolean(KEY_RESULT);
			if (mWaitProgress != null && mWaitProgress.isShowing())
				mWaitProgress.dismiss();
            switch (msg.what) {
                case MSG_CLOSE_RESULT:
                    if (result) {
                        mToast.showToast(R.string.smartcard_close_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        mCloseBtn.setEnabled(false);
                        mText.setText("errCode: " + errCode + " " + SmartCardManager.errCode2String(errCode));
                        mToast.showToast(R.string.smartcard_close_failed);
                    }
                    mOpenBtn.setEnabled(true);
					mWriteMemBtn.setEnabled(false);
					mReadMemBtn.setEnabled(false);
					mWriteCounterBtn.setEnabled(false);
					mReadCounterBtn.setEnabled(false);
					mReloadBtn.setEnabled(false);
					mAuthBtn.setEnabled(false);
					mVerifyBtn.setEnabled(false);

                    mOpenFlag = false;
                    break;


                case MSG_OPEN_RESULT:
                    if (result) {
                        mCloseBtn.setEnabled(true);
						mWriteMemBtn.setEnabled(true);
						mReadMemBtn.setEnabled(true);
						mWriteCounterBtn.setEnabled(true);
						mReadCounterBtn.setEnabled(true);
						mReloadBtn.setEnabled(true);
						mAuthBtn.setEnabled(true);
						mVerifyBtn.setEnabled(true);
                        mOpenFlag = true;
                        mToast.showToast(R.string.smartcard_open_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        if (errCode == SmartCardManager.SCR_ERR_NO_INIT) {
                            init();
                            if (mSlotCount > 1) {
                                mSlotDialog.show();
                            } else {
                                open();
                            }
                        } else {
                            mOpenBtn.setEnabled(true);
							mText.setText("errCode: " + errCode + " " + SmartCardManager.errCode2String(errCode));
                            mToast.showToast(R.string.smartcard_open_failed);
                        }
                    }
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.sle6636);
        setTitle(R.string.smartcard_mode_sle6636);

        mText = findViewById(R.id.text_result);
        mEditMemAddr = findViewById(R.id.edit_mem_addr);
        mEditMemLength = findViewById(R.id.edit_mem_len);
        mEditMemData = findViewById(R.id.edit_mem_data);
        mEditCounterAddr = findViewById(R.id.edit_counter_addr);
        mEditCounterData = findViewById(R.id.edit_counter_data);
        mEditReloadAddr = findViewById(R.id.edit_reload_addr);
        mEditAuthKey = findViewById(R.id.edit_key);
        mEditAuthClock = findViewById(R.id.edit_clock);
        mEditAuthChallenge = findViewById(R.id.edit_challenge);
        mEditTc1 = findViewById(R.id.edit_tc1);
        mEditTc2 = findViewById(R.id.edit_tc2);
        mEditTc3 = findViewById(R.id.edit_tc3);

        mOpenBtn = findViewById(R.id.btn_open);
        mCloseBtn = findViewById(R.id.btn_close);
        mWriteMemBtn = findViewById(R.id.btn_write_mem);
        mReadMemBtn = findViewById(R.id.btn_read_mem);
        mWriteCounterBtn = findViewById(R.id.btn_write_counter);
        mReadCounterBtn = findViewById(R.id.btn_read_counter);
        mReloadBtn = findViewById(R.id.btn_reload);
        mAuthBtn = findViewById(R.id.btn_auth);
        mVerifyBtn = findViewById(R.id.btn_verify);

        mCloseBtn.setEnabled(false);
		mWriteMemBtn.setEnabled(false);
		mReadMemBtn.setEnabled(false);
		mWriteCounterBtn.setEnabled(false);
		mReadCounterBtn.setEnabled(false);
		mReloadBtn.setEnabled(false);
		mAuthBtn.setEnabled(false);
		mVerifyBtn.setEnabled(false);


		mWaitProgress =  new ProgressDialog(this);  
		mWaitProgress.setCancelable(false);
		mWaitProgress.setProgressStyle(ProgressDialog.STYLE_SPINNER);

        setReaderSlotView();

		mSmartCardManager = new SmartCardManager();
		mToast = new MyToast(this);
		//we just init reader to get slot count, unnecessary for single slot.
        init();
        mSmartCardManager.deinit();
    }

    @Override
    protected void onPause() {
        super.onPause();
		mToast.cancel();
    }

    @Override
    public void onDestroy() {
        //NOTE: power off card and deinit
        Log.d(TAG, "onDestroy()");
        if (mOpenFlag) {
            close();
        } else {
            mSmartCardManager.deinit();
            Log.d(TAG, "Deinit");
            if (mCloseTask != null && mCloseTask.getStatus() != AsyncTask.Status.FINISHED) {
                mCloseTask.cancel(true);
            }
        }
        if (mOpenTask != null && mOpenTask.getStatus() != AsyncTask.Status.FINISHED) {
            mOpenTask.cancel(true);
        }

        super.onDestroy();
    }

	public void onOpenBtnClick(View v) {
		if (mSlotCount > 1) {
			mSlotDialog.show();
		} else {
			open();
		}
	}

	public void onCloseBtnClick(View v) {
		mText.setText("");
		mWaitProgress.setMessage("Closing...");
		mWaitProgress.show();
		close();
	}

	public void OnWriteMemClick(View v) {
		int[] returnLen = new int[1];
		byte[] returnData = new byte[3];
		String tmp = mEditMemAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditMemLength.getText().toString();
		byte[] writeLen = Utils.stringToBytes(tmp);
		tmp = mEditMemData.getText().toString();
		byte[] writeData = Utils.stringToBytes(tmp);
		if (writeData.length > MAX_WRITE_BYTE_LEN)
			writeLen[0] = MAX_WRITE_BYTE_LEN;

		int code = mSmartCardManager.SLE6636CmdWriteMemory(0, addr[0], writeLen[0], writeData, (byte)0, returnData, returnLen);
		if (code == 0) {
			mText.setText("WriteMem success:"+Utils.bytesToHexString(returnData));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnReadMemClick(View v) {
		int[] returnLen = new int[1];
		byte[] returnData = new byte[MAX_WRITE_BYTE_LEN];
		String tmp = mEditMemAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditMemLength.getText().toString();
		byte[] readLen = Utils.stringToBytes(tmp);
		if (readLen[0] > MAX_WRITE_BYTE_LEN)
			readLen[0] = MAX_WRITE_BYTE_LEN;

		int code = mSmartCardManager.SLE6636CmdReadMemory(addr[0], readLen[0], readLen[0], returnData, returnLen);
		if (code == 0) {
			mText.setText("ReadMem success:"+Utils.bytesToHexString(returnData));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnWriteCounterClick(View v) {
		int[] returnLen = new int[1];
		byte[] returnData = new byte[3];
		String tmp = mEditCounterAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditCounterData.getText().toString();
		byte[] writeData = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE6636CmdWriteCounter(addr[0], writeData[0], (byte)0, returnData, returnLen);
		if (code == 0) {
			mText.setText("WriteCounter success:"+Utils.bytesToHexString(returnData));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnReadCounterClick(View v) {
		int[] returnLen = new int[1];
		byte[] returnData = new byte[8];
		String tmp = mEditCounterAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE6636CmdReadCounters((byte)8, returnData, returnLen);
		if (code == 0) {
			mText.setText("ReadCounter success:"+Utils.bytesToHexString(returnData));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnReloadClick(View v) {
		int[] returnLen = new int[1];
		byte[] returnData = new byte[3];
		String tmp = mEditReloadAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE6636CmdReload(addr[0], (byte)3, returnData, returnLen);
		if (code == 0) {
			mText.setText("Reload success:"+Utils.bytesToHexString(returnData));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnAuthenticationClick(View v) {
		int[] returnLen = new int[1];
		byte[] returnData = new byte[5];
		String tmp = mEditAuthKey.getText().toString();
		byte[] key = Utils.stringToBytes(tmp);
		tmp = mEditAuthClock.getText().toString();
		byte[] clock = Utils.stringToBytes(tmp);
		tmp = mEditAuthChallenge.getText().toString();
		byte[] challenge = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE6636CmdAuthentication(key[0], clock[0], (byte)challenge.length, challenge, (byte)0, returnData, returnLen);
		if (code == 0) {
			mText.setText("Auth success:"+Utils.bytesToHexString(returnData));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnVerificationClick(View v) {
		int[] returnLen = new int[1];
		String tmp = mEditTc1.getText().toString();
		byte[] tc1 = Utils.stringToBytes(tmp);
		tmp = mEditTc2.getText().toString();
		byte[] tc2 = Utils.stringToBytes(tmp);
		tmp = mEditTc3.getText().toString();
		byte[] tc3 = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.SLE6636CmdVerification(tc1[0], tc2[0], tc3[0], (byte)0, null, returnLen);
		if (code == 0) {
			mText.setText("Verify success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

    private void init() {
        int errCode;
        String errMsg = null;
        try {
			//init SLE6636 mode
			mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_SLE6636);
            Log.d(TAG, "got slot count:" + mSlotCount);
        } catch (SmartPosException e) {
            mOpenBtn.setEnabled(false);
            errCode = e.getErrorCode();
            switch (errCode) {
                case SmartCardManager.SCR_ERR_INIT:
                    errMsg = "Reader init error!";
                    break;
            }
            Log.d(TAG, "init errCode:" + errCode + " " + errMsg);
            mText.setText("errCode: " + errCode + "  " + errMsg);
            mToast.showToast(R.string.smartcard_init_err);
        }
    }

    private void open() {
        Log.d(TAG, "open slot:" + mSlotSelected);
        mOpenBtn.setEnabled(false);
        mOpenTask = new OpenTask();
        mOpenTask.execute(this);
    }

    private void close() {
        mCloseBtn.setEnabled(false);
        mCloseTask = new CloseTask();
        mCloseTask.execute();
    }

    private void setReaderSlotView() {
        final String[] arraySlot = new String[]{"slot:0", "Slot:1"};
        mSlotDialog = new AlertDialog.Builder(this);
        DialogInterface.OnClickListener Select = new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                mSlotSelected = (byte) which;
            }
        };

        DialogInterface.OnClickListener OkClick = new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                open();
            }
        };

        mSlotDialog.setPositiveButton("OK", OkClick);
        mSlotDialog.setTitle("Select Slot Number");
        mSlotDialog.setSingleChoiceItems(arraySlot, 0, Select);
    }


    /**
     * @brief helper class for init smartcard reader
     */
    private class OpenTask extends AsyncTask<Context, Void, Boolean> {
        private int errCode;

		@Override 
		protected void onPreExecute() {
			mWaitProgress.setMessage("Opening...");
			mWaitProgress.show();
		}

        @Override
        protected Boolean doInBackground(Context... params) {
            if (isCancelled()) {
                return false;
            }
            try {
				//init SLE6636 mode
                mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_SLE6636);
                mSmartCardManager.selectSlot(mSlotSelected);
                Log.d(TAG, "Select slot:" + mSlotSelected);
                mSmartCardManager.powerOn();
                Log.d(TAG, "Power On");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            try {
                Message msg = new Message();
                msg.what = MSG_OPEN_RESULT;
                Bundle bundle = new Bundle();
                bundle.putBoolean(KEY_RESULT, result);
                if (result) {
                } else {
                    bundle.putInt(KEY_ERR_CODE, errCode);
                }
                msg.setData(bundle);
                mHandler.sendMessage(msg);
            } catch (Exception e) {
                Log.d(TAG, "open task err!");
            }
        }
    }

    /**
     * @brief helper class for deinit smartcard reader
     */
    private class CloseTask extends AsyncTask<Void, Void, Boolean> {
        int errCode;

        @Override
        protected Boolean doInBackground(Void... params) {
            if (isCancelled()) {
                return false;
            }
            try {
                mSmartCardManager.powerOff();
                Log.d(TAG, "Power Off");
                mSmartCardManager.deinit();
                Log.d(TAG, "Deinit");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            Message msg = new Message();
            msg.what = MSG_CLOSE_RESULT;
            Bundle bundle = new Bundle();
            bundle.putBoolean(KEY_RESULT, result);
            if (!result) {
                bundle.putInt(KEY_ERR_CODE, errCode);
            }
            msg.setData(bundle);
            mHandler.sendMessage(msg);
        }
    }
}
