
package com.paydevice.smartpos.demo.smartcard;

import android.annotation.SuppressLint;
import android.support.v7.app.AppCompatActivity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.RadioGroup;
import android.widget.Spinner;
import android.widget.TextView;

import com.paydevice.smartpos.demo.R;
import com.paydevice.smartpos.demo.MyToast;
import com.paydevice.smartpos.demo.Utils;
import com.paydevice.smartpos.sdk.SmartPosException;
import com.paydevice.smartpos.sdk.smartcard.SmartCardManager;

public class AT88SC1608Activity extends AppCompatActivity implements RadioGroup.OnCheckedChangeListener {

    private static final String TAG = "AT88SC1608Activity";

    private static final String KEY_RESULT = "result";
    private static final String KEY_ERR_CODE = "code";

	private static final int MAX_WRITE_LENGTH = 256;
	private static final boolean VERIFY_TYPE_WRITE = false;
	private static final boolean VERIFY_TYPE_READ = true;

    private static final int MSG_OPEN_RESULT = 1;
    private static final int MSG_CLOSE_RESULT = 2;
    private boolean mOpenFlag = false;
    
    private SmartCardManager mSmartCardManager;

	private MyToast mToast;
    private TextView mText;
    private TextView mEditSetUserAddr;
    private TextView mEditUserAddr;
    private TextView mEditUserLen;
    private TextView mEditUserData;
    private TextView mEditCfgAddr;
    private TextView mEditCfgLen;
    private TextView mEditCfgData;
    private TextView mEditPwd1;
    private TextView mEditPwd2;
    private TextView mEditPwd3;

	private ProgressDialog mWaitProgress; 

    private Button mOpenBtn;
    private Button mCloseBtn;
    private Button mSetUserAddeBtn;
    private Button mWriteUserBtn;
    private Button mReadUserBtn;
    private Button mWriteConfigBtn;
    private Button mReadConfigBtn;
    private Button mVerifyPwdBtn;
	private boolean mVerifyType = VERIFY_TYPE_WRITE;
	private Spinner mZoneSpinner;

    private OpenTask mOpenTask;
    private CloseTask mCloseTask;

    private Builder mSlotDialog;
    private int mSlotSelected = 0;
    private int mSlotCount = 1;

    @SuppressLint("HandlerLeak")
    public Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            Boolean result = msg.getData().getBoolean(KEY_RESULT);
			if (mWaitProgress != null && mWaitProgress.isShowing())
				mWaitProgress.dismiss();
            switch (msg.what) {
                case MSG_CLOSE_RESULT:
                    if (result) {
                        mToast.showToast(R.string.smartcard_close_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        mCloseBtn.setEnabled(false);
                        mText.setText("errCode: " + errCode + " " + SmartCardManager.errCode2String(errCode));
                        mToast.showToast(R.string.smartcard_close_failed);
                    }
                    mOpenBtn.setEnabled(true);
					mSetUserAddeBtn.setEnabled(false);
					mWriteUserBtn.setEnabled(false);
					mReadUserBtn.setEnabled(false);
					mWriteConfigBtn.setEnabled(false);
					mReadConfigBtn.setEnabled(false);
					mVerifyPwdBtn.setEnabled(false);

                    mOpenFlag = false;
                    break;


                case MSG_OPEN_RESULT:
                    if (result) {
                        mCloseBtn.setEnabled(true);
						mSetUserAddeBtn.setEnabled(true);
						mWriteUserBtn.setEnabled(true);
						mReadUserBtn.setEnabled(true);
						mWriteConfigBtn.setEnabled(true);
						mReadConfigBtn.setEnabled(true);
						mVerifyPwdBtn.setEnabled(true);

                        mOpenFlag = true;
                        mToast.showToast(R.string.smartcard_open_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        if (errCode == SmartCardManager.SCR_ERR_NO_INIT) {
                            init();
                            if (mSlotCount > 1) {
                                mSlotDialog.show();
                            } else {
                                open();
                            }
                        } else {
                            mOpenBtn.setEnabled(true);
							mText.setText("errCode: " + errCode + " " + SmartCardManager.errCode2String(errCode));
                            mToast.showToast(R.string.smartcard_open_failed);
                        }
                    }
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.at88sc1608);
        setTitle(R.string.smartcard_mode_at88sc1608);

        mText = findViewById(R.id.text_result);
        mEditSetUserAddr = findViewById(R.id.edit_set_user_addr);
        mEditUserAddr = findViewById(R.id.edit_user_addr);
        mEditUserLen = findViewById(R.id.edit_user_len);
        mEditUserData = findViewById(R.id.edit_user_data);
        mEditCfgAddr = findViewById(R.id.edit_cfg_addr);
        mEditCfgLen = findViewById(R.id.edit_cfg_len);
        mEditCfgData = findViewById(R.id.edit_cfg_data);
        mEditPwd1 = findViewById(R.id.edit_pwd1);
        mEditPwd2 = findViewById(R.id.edit_pwd2);
        mEditPwd3 = findViewById(R.id.edit_pwd3);

        mOpenBtn = findViewById(R.id.btn_open);
        mCloseBtn = findViewById(R.id.btn_close);
        mSetUserAddeBtn = findViewById(R.id.btn_set_user_zone_addr);
        mWriteUserBtn = findViewById(R.id.btn_write_user_zone);
        mReadUserBtn = findViewById(R.id.btn_read_user_zone);
        mWriteConfigBtn = findViewById(R.id.btn_write_cfg);
        mReadConfigBtn = findViewById(R.id.btn_read_cfg);
        mVerifyPwdBtn = findViewById(R.id.btn_verify_pwd);

        mCloseBtn.setEnabled(false);
        mSetUserAddeBtn.setEnabled(false);
        mWriteUserBtn.setEnabled(false);
        mReadUserBtn.setEnabled(false);
        mWriteConfigBtn.setEnabled(false);
        mReadConfigBtn.setEnabled(false);
        mVerifyPwdBtn.setEnabled(false);

		mWaitProgress =  new ProgressDialog(this);  
		mWaitProgress.setCancelable(false);
		mWaitProgress.setProgressStyle(ProgressDialog.STYLE_SPINNER);

		RadioGroup radioGroup = (RadioGroup) findViewById(R.id.radioGroup);        
		radioGroup.setOnCheckedChangeListener(this);

        setReaderSlotView();
		String[] zone = {"0","1","2","3","4","5","6","7"};
		ArrayAdapter<String> adapter= new ArrayAdapter<String>(this,
				android.R.layout.simple_spinner_item, zone);
		mZoneSpinner = (Spinner) findViewById(R.id.spinner_zone);
		mZoneSpinner.setAdapter(adapter);

		mSmartCardManager = new SmartCardManager();
		mToast = new MyToast(this);
		//we just init reader to get slot count, unnecessary for single slot.
        init();
        mSmartCardManager.deinit();
    }

    @Override
    protected void onPause() {
        super.onPause();
		mToast.cancel();
    }

    @Override
    public void onDestroy() {
        //NOTE: power off card and deinit
        Log.d(TAG, "onDestroy()");
        if (mOpenFlag) {
            close();
        } else {
            mSmartCardManager.deinit();
            Log.d(TAG, "Deinit");
            if (mCloseTask != null && mCloseTask.getStatus() != AsyncTask.Status.FINISHED) {
                mCloseTask.cancel(true);
            }
        }
        if (mOpenTask != null && mOpenTask.getStatus() != AsyncTask.Status.FINISHED) {
            mOpenTask.cancel(true);
        }

        super.onDestroy();
    }

	@Override
	public void onCheckedChanged(RadioGroup group, int checkedId) {
		switch (checkedId) {
			case R.id.radio_write:
				Log.d(TAG, "select write byte");
				mVerifyType = VERIFY_TYPE_WRITE;
				break;
			case R.id.radio_read:
				Log.d(TAG, "select read byte");
				mVerifyType = VERIFY_TYPE_READ;
				break;
		}
	}

	public void onOpenBtnClick(View v) {
		if (mSlotCount > 1) {
			mSlotDialog.show();
		} else {
			open();
		}
	}

	public void onCloseBtnClick(View v) {
		mText.setText("");
		mWaitProgress.setMessage("Closing...");
		mWaitProgress.show();
		close();
	}

	public void OnSetUserZoneAddrClick(View view){
		String tmp = mEditSetUserAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		int code = mSmartCardManager.AT88SC1608CmdSetUserZoneAddress(addr[0]);

		if (code == 0) {
			mText.setText("set user zone addr success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnWriteUserZoneClick(View view){
		String tmp = mEditUserAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditUserData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);
		int code = mSmartCardManager.AT88SC1608CmdWriteUserZone(addr[0], (byte)data.length, data);

		if (code == 0) {
			mText.setText("write user zone success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnReadUserZoneClick(View view){
		int[] returnLen = new int[1];
		String tmp = mEditUserAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditUserLen.getText().toString();
		int readLen = Integer.parseInt(tmp, 16);
		if (readLen > MAX_WRITE_LENGTH)
			readLen = MAX_WRITE_LENGTH;
		byte[] readData = new byte[readLen];

		int code = mSmartCardManager.AT88SC1608CmdReadUserZone(addr[0], (byte)readLen, readData, returnLen);
		if (code == 0) {
			mText.setText("ReadUserZone:"+Utils.bytesToHexString(readData));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnWriteConfigZoneClick(View view){
		String tmp = mEditCfgAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditCfgData.getText().toString();
		byte[] data = Utils.stringToBytes(tmp);

		int code = mSmartCardManager.AT88SC1608CmdWriteConfigurationZone(addr[0], (byte)data.length, data);
		if (code == 0) {
			mText.setText("Write config zone success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnReadConfigZoneClick(View view){
		int[] returnLen = new int[1];
		String tmp = mEditCfgAddr.getText().toString();
		byte[] addr = Utils.stringToBytes(tmp);
		tmp = mEditCfgLen.getText().toString();
		int readLen = Integer.parseInt(tmp, 16);
		if (readLen > MAX_WRITE_LENGTH)
			readLen = MAX_WRITE_LENGTH;
		byte[] readData = new byte[readLen];

		int code = mSmartCardManager.AT88SC1608CmdReadConfigurationZone(addr[0], (byte)readLen, readData, returnLen);
		if (code == 0) {
			mText.setText("ReadConfigZone:"+Utils.bytesToHexString(readData));
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

	public void OnVerifyPwdClick(View view){
		String tmp = mEditPwd1.getText().toString();
		byte[] pwd1 = Utils.stringToBytes(tmp);
		tmp = mEditPwd2.getText().toString();
		byte[] pwd2 = Utils.stringToBytes(tmp);
		tmp = mEditPwd3.getText().toString();
		byte[] pwd3 = Utils.stringToBytes(tmp);
		byte zone = (byte)mZoneSpinner.getSelectedItemId();

		int code = mSmartCardManager.AT88SC1608CmdVerifyPassword(zone, mVerifyType, pwd1[0], pwd2[0], pwd3[0]);
		if (code == 0) {
			mText.setText("Verify password success");
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

    private void init() {
        int errCode;
        String errMsg = null;
        try {
			//init AT88SC1608 mode
			mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_AT88SC1608);
            Log.d(TAG, "got slot count:" + mSlotCount);
        } catch (SmartPosException e) {
            mOpenBtn.setEnabled(false);
            errCode = e.getErrorCode();
            switch (errCode) {
                case SmartCardManager.SCR_ERR_INIT:
                    errMsg = "Reader init error!";
                    break;
            }
            Log.d(TAG, "init errCode:" + errCode + " " + errMsg);
            mText.setText("errCode: " + errCode + "  " + errMsg);
            mToast.showToast(R.string.smartcard_init_err);
        }
    }

    private void open() {
        Log.d(TAG, "open slot:" + mSlotSelected);
        mOpenBtn.setEnabled(false);
        mOpenTask = new OpenTask();
        mOpenTask.execute(this);
    }

    private void close() {
        mCloseBtn.setEnabled(false);
        mCloseTask = new CloseTask();
        mCloseTask.execute();
    }

    private void setReaderSlotView() {
        final String[] arraySlot = new String[]{"slot:0", "Slot:1"};
        mSlotDialog = new AlertDialog.Builder(this);
        DialogInterface.OnClickListener Select = new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                mSlotSelected = (byte) which;
            }
        };

        DialogInterface.OnClickListener OkClick = new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                open();
            }
        };

        mSlotDialog.setPositiveButton("OK", OkClick);
        mSlotDialog.setTitle("Select Slot Number");
        mSlotDialog.setSingleChoiceItems(arraySlot, 0, Select);
    }


    /**
     * @brief helper class for init smartcard reader
     */
    private class OpenTask extends AsyncTask<Context, Void, Boolean> {
        private int errCode;

		@Override 
		protected void onPreExecute() {
			mWaitProgress.setMessage("Opening...");
			mWaitProgress.show();
		}

        @Override
        protected Boolean doInBackground(Context... params) {
            if (isCancelled()) {
                return false;
            }
            try {
				//init AT88SC1608 mode
                mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_AT88SC1608);
                mSmartCardManager.selectSlot(mSlotSelected);
                Log.d(TAG, "Select slot:" + mSlotSelected);
                mSmartCardManager.powerOn();
                Log.d(TAG, "Power On");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
			mWaitProgress.dismiss();
            try {
                Message msg = new Message();
                msg.what = MSG_OPEN_RESULT;
                Bundle bundle = new Bundle();
                bundle.putBoolean(KEY_RESULT, result);
                if (result) {
                } else {
                    bundle.putInt(KEY_ERR_CODE, errCode);
                }
                msg.setData(bundle);
                mHandler.sendMessage(msg);
            } catch (Exception e) {
                Log.d(TAG, "open task err!");
            }
        }
    }

    /**
     * @brief helper class for deinit smartcard reader
     */
    private class CloseTask extends AsyncTask<Void, Void, Boolean> {
        int errCode;

        @Override
        protected Boolean doInBackground(Void... params) {
            if (isCancelled()) {
                return false;
            }
            try {
                mSmartCardManager.powerOff();
                Log.d(TAG, "Power Off");
                mSmartCardManager.deinit();
                Log.d(TAG, "Deinit");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            Message msg = new Message();
            msg.what = MSG_CLOSE_RESULT;
            Bundle bundle = new Bundle();
            bundle.putBoolean(KEY_RESULT, result);
            if (!result) {
                bundle.putInt(KEY_ERR_CODE, errCode);
            }
            msg.setData(bundle);
            mHandler.sendMessage(msg);
        }
    }
}
