
package com.paydevice.smartpos.demo.smartcard;

import android.annotation.SuppressLint;
import android.support.v7.app.AppCompatActivity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

import com.paydevice.smartpos.demo.R;
import com.paydevice.smartpos.demo.MyToast;
import com.paydevice.smartpos.demo.Utils;
import com.paydevice.smartpos.sdk.SmartPosException;
import com.paydevice.smartpos.sdk.smartcard.SmartCardManager;

public class AT45D041Activity extends AppCompatActivity {

    private static final String TAG = "AT45D041Activity";

    private static final String KEY_RESULT = "result";
    private static final String KEY_ERR_CODE = "code";

	private final static byte Op_MainMRead = (byte)0x52;
	private final static byte Op_MainPage2Buff1 = (byte)0x53;
	private final static byte Op_Buff1Read = (byte)0x54;
	private final static byte Op_MainPage2Buff2 = (byte)0x55;
	private final static byte Op_Buff2Read = (byte)0x56;
	private final static byte Op_StatusRegRead = (byte)0x57;
	private final static byte Op_AutoPageReWriteBuff1 = (byte)0x58;
	private final static byte Op_AutoPageReWriteBuff2 = (byte)0x59;
	private final static byte Op_MainMPageBuff1Comp = (byte)0x60;
	private final static byte Op_MainMPageBuff2Comp = (byte)0x61;
	private final static byte Op_MainMPageProgBuff1 = (byte)0x82;
	private final static byte Op_Buff1toMainMPageProgWithErase = (byte)0x83;
	private final static byte Op_Buff1Write = (byte)0x84;
	private final static byte Op_MainMPageProgBuff2 = (byte)0x85;
	private final static byte Op_Buff2toMainMPageProgWithErase = (byte)0x86;
	private final static byte Op_Buff2Write = (byte)0x87;
	private final static byte Op_Buff1toMainMPageProgWithoutErase = (byte)0x88;
	private final static byte Op_Buff2toMainMPageProgWithoutErase = (byte)0x89;

    private static final int MSG_OPEN_RESULT = 1;
    private static final int MSG_CLOSE_RESULT = 2;
    private boolean mOpenFlag = false;
    
    private SmartCardManager mSmartCardManager;

	private MyToast mToast;
    private TextView mText;
    private TextView mEditAddr;
    private TextView mEditPageNum;
    private TextView mEditLength;
    private TextView mEditWriteData;

	private ProgressDialog mWaitProgress; 

    private Button mOpenBtn;
    private Button mCloseBtn;
    private Button mMainMemReadBtn;
    private Button mBuff1ReadBtn;
    private Button mBuff2ReadBtn;
    private Button mMainMemBuf1XfrBtn;
    private Button mMainMemBuf2XfrBtn;
    private Button mMainMemBuf1CompBtn;
    private Button mMainMemBuf2CompBtn;
    private Button mBuff1WriteBtn;
    private Button mBuff2WriteBtn;
    private Button mB1MemEraseBtn;
    private Button mB2MemEraseBtn;
    private Button mB1MemNoEraseBtn;
    private Button mB2MemNoEraseBtn;
    private Button mMemProgB1Btn;
    private Button mMemProgB2Btn;
    private Button mAutoRewriteB1Btn;
    private Button mAutoRewriteB2Btn;
    private Button mGetStatusRegBtn;

    private OpenTask mOpenTask;
    private CloseTask mCloseTask;

    private Builder mSlotDialog;
    private int mSlotSelected = 0;
    private int mSlotCount = 1;

    @SuppressLint("HandlerLeak")
    public Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            Boolean result = msg.getData().getBoolean(KEY_RESULT);
			if (mWaitProgress != null && mWaitProgress.isShowing())
				mWaitProgress.dismiss();
            switch (msg.what) {
                case MSG_CLOSE_RESULT:
                    if (result) {
                        mToast.showToast(R.string.smartcard_close_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        mCloseBtn.setEnabled(false);
                        mText.setText("errCode: " + errCode + " " + SmartCardManager.errCode2String(errCode));
                        mToast.showToast(R.string.smartcard_close_failed);
                    }
                    mOpenBtn.setEnabled(true);
					mMainMemReadBtn.setEnabled(false);
					mBuff1ReadBtn.setEnabled(false);
					mBuff2ReadBtn.setEnabled(false);
					mMainMemBuf1XfrBtn.setEnabled(false);
					mMainMemBuf2XfrBtn.setEnabled(false);
					mMainMemBuf1CompBtn.setEnabled(false);
					mMainMemBuf2CompBtn.setEnabled(false);
					mBuff1WriteBtn.setEnabled(false);
					mBuff2WriteBtn.setEnabled(false);
					mB1MemEraseBtn.setEnabled(false);
					mB2MemEraseBtn.setEnabled(false);
					mB1MemNoEraseBtn.setEnabled(false);
					mB2MemNoEraseBtn.setEnabled(false);
					mMemProgB1Btn.setEnabled(false);
					mMemProgB2Btn.setEnabled(false);
					mAutoRewriteB1Btn.setEnabled(false);
					mAutoRewriteB2Btn.setEnabled(false);
					mGetStatusRegBtn.setEnabled(false);

                    mOpenFlag = false;
                    break;


                case MSG_OPEN_RESULT:
                    if (result) {
                        mCloseBtn.setEnabled(true);
						mMainMemReadBtn.setEnabled(true);
						mBuff1ReadBtn.setEnabled(true);
						mBuff2ReadBtn.setEnabled(true);
						mMainMemBuf1XfrBtn.setEnabled(true);
						mMainMemBuf2XfrBtn.setEnabled(true);
						mMainMemBuf1CompBtn.setEnabled(true);
						mMainMemBuf2CompBtn.setEnabled(true);
						mBuff1WriteBtn.setEnabled(true);
						mBuff2WriteBtn.setEnabled(true);
						mB1MemEraseBtn.setEnabled(true);
						mB2MemEraseBtn.setEnabled(true);
						mB1MemNoEraseBtn.setEnabled(true);
						mB2MemNoEraseBtn.setEnabled(true);
						mMemProgB1Btn.setEnabled(true);
						mMemProgB2Btn.setEnabled(true);
						mAutoRewriteB1Btn.setEnabled(true);
						mAutoRewriteB2Btn.setEnabled(true);
						mGetStatusRegBtn.setEnabled(true);
                        mOpenFlag = true;
                        mToast.showToast(R.string.smartcard_open_success);
                    } else {
						int errCode = msg.getData().getInt(KEY_ERR_CODE);
                        if (errCode == SmartCardManager.SCR_ERR_NO_INIT) {
                            init();
                            if (mSlotCount > 1) {
                                mSlotDialog.show();
                            } else {
                                open();
                            }
                        } else {
                            mOpenBtn.setEnabled(true);
							mText.setText("errCode: " + errCode + " " + SmartCardManager.errCode2String(errCode));
                            mToast.showToast(R.string.smartcard_open_failed);
                        }
                    }
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.at45d041);
        setTitle(R.string.smartcard_mode_at45d041);

        mText = findViewById(R.id.text_result);
        mEditAddr = findViewById(R.id.edit_write_addr);
        mEditPageNum = findViewById(R.id.edit_write_pagesize);
        mEditWriteData = findViewById(R.id.edit_write_data);
        mEditLength = findViewById(R.id.edit_read_length);

        mOpenBtn = findViewById(R.id.btn_open);
        mCloseBtn = findViewById(R.id.btn_close);
		mMainMemReadBtn = findViewById(R.id.btn_main_mem_read);
		mBuff1ReadBtn = findViewById(R.id.btn_buff1_read);
		mBuff2ReadBtn = findViewById(R.id.btn_buff2_read);
		mMainMemBuf1XfrBtn = findViewById(R.id.btn_main_mem_buf1_xfr);
		mMainMemBuf2XfrBtn = findViewById(R.id.btn_main_mem_buf2_xfr);
		mMainMemBuf1CompBtn = findViewById(R.id.btn_main_mem_buf1_comp);
		mMainMemBuf2CompBtn = findViewById(R.id.btn_main_mem_buf2_comp);
		mBuff1WriteBtn = findViewById(R.id.btn_buff1_write);
		mBuff2WriteBtn = findViewById(R.id.btn_buff2_write);
		mB1MemEraseBtn = findViewById(R.id.btn_b1_mem_erase);
		mB2MemEraseBtn = findViewById(R.id.btn_b2_mem_erase);
		mB1MemNoEraseBtn = findViewById(R.id.btn_b1_mem_no_erase);
		mB2MemNoEraseBtn = findViewById(R.id.btn_b2_mem_no_erase);
		mMemProgB1Btn = findViewById(R.id.btn_mem_prog_b1);
		mMemProgB2Btn = findViewById(R.id.btn_mem_prog_b2);
		mAutoRewriteB1Btn = findViewById(R.id.btn_auto_rewrite_b1);
		mAutoRewriteB2Btn = findViewById(R.id.btn_auto_rewrite_b2);
		mGetStatusRegBtn = findViewById(R.id.btn_get_status_reg);

        mCloseBtn.setEnabled(false);
		mMainMemReadBtn.setEnabled(false);
		mBuff1ReadBtn.setEnabled(false);
		mBuff2ReadBtn.setEnabled(false);
		mMainMemBuf1XfrBtn.setEnabled(false);
		mMainMemBuf2XfrBtn.setEnabled(false);
		mMainMemBuf1CompBtn.setEnabled(false);
		mMainMemBuf2CompBtn.setEnabled(false);
		mBuff1WriteBtn.setEnabled(false);
		mBuff2WriteBtn.setEnabled(false);
		mB1MemEraseBtn.setEnabled(false);
		mB2MemEraseBtn.setEnabled(false);
		mB1MemNoEraseBtn.setEnabled(false);
		mB2MemNoEraseBtn.setEnabled(false);
		mMemProgB1Btn.setEnabled(false);
		mMemProgB2Btn.setEnabled(false);
		mAutoRewriteB1Btn.setEnabled(false);
		mAutoRewriteB2Btn.setEnabled(false);
		mGetStatusRegBtn.setEnabled(false);

		mWaitProgress =  new ProgressDialog(this);  
		mWaitProgress.setCancelable(false);
		mWaitProgress.setProgressStyle(ProgressDialog.STYLE_SPINNER);

        setReaderSlotView();

		mSmartCardManager = new SmartCardManager();
		mToast = new MyToast(this);
		//we just init reader to get slot count, unnecessary for single slot.
        init();
        mSmartCardManager.deinit();
    }

    @Override
    protected void onPause() {
        super.onPause();
		mToast.cancel();
    }

    @Override
    public void onDestroy() {
        //NOTE: power off card and deinit
        Log.d(TAG, "onDestroy()");
        if (mOpenFlag) {
            close();
        } else {
            mSmartCardManager.deinit();
            Log.d(TAG, "Deinit");
            if (mCloseTask != null && mCloseTask.getStatus() != AsyncTask.Status.FINISHED) {
                mCloseTask.cancel(true);
            }
        }
        if (mOpenTask != null && mOpenTask.getStatus() != AsyncTask.Status.FINISHED) {
            mOpenTask.cancel(true);
        }

        super.onDestroy();
    }

	public void onOpenBtnClick(View v) {
		if (mSlotCount > 1) {
			mSlotDialog.show();
		} else {
			open();
		}
	}

	public void onCloseBtnClick(View v) {
		mText.setText("");
		mWaitProgress.setMessage("Closing...");
		mWaitProgress.show();
		close();
	}

	public void OnMainMemReadClick(View view) {
		sendCmd(Op_MainMRead);
	}

	public void OnBuff1ReadClick(View view) {
		sendCmd(Op_Buff1Read);
	}

	public void OnBuff2ReadClick(View view) {
		sendCmd(Op_Buff2Read);
	}

	public void OnMainMemPagetoBuf1XfrClick(View view) {
		sendCmd(Op_MainPage2Buff1);
	}

	public void OnMainMemPagetoBuf2XfrClick(View view) {
		sendCmd(Op_MainPage2Buff2);
	}

	public void OnMainMemPagetoBuf1CompClick(View view) {
		sendCmd(Op_MainMPageBuff1Comp);
	}

	public void OnMainMemPagetoBuf2CompClick(View view) {
		sendCmd(Op_MainMPageBuff2Comp);
	}

	public void OnBuff1WriteClick(View view) {
		sendCmd(Op_Buff1Write);
	}

	public void OnBuff2WriteClick(View view) {
		sendCmd(Op_Buff2Write);
	}

	public void OnB1toMwithEraseClick(View view) {
		sendCmd(Op_Buff1toMainMPageProgWithErase);
	}

	public void OnB2toMwithEraseClick(View view) {
		sendCmd(Op_Buff2toMainMPageProgWithErase);
	}

	public void OnB1toMwithoutEraseClick(View view) {
		sendCmd(Op_Buff1toMainMPageProgWithoutErase);
	}

	public void OnB2toMwithoutEraseClick(View view) {
		sendCmd(Op_Buff2toMainMPageProgWithoutErase);
	}

	public void OnMemProgThrB1Click(View view) {
		sendCmd(Op_MainMPageProgBuff1);
	}

	public void OnMemProgThrB2Click(View view) {
		sendCmd(Op_MainMPageProgBuff2);
	}

	public void OnAutoReWriteThrB1Click(View view) {
		sendCmd(Op_AutoPageReWriteBuff1);
	}

	public void OnAutoReWriteThrB2Click(View view) {
		sendCmd(Op_AutoPageReWriteBuff2);
	}

	public void OnGetStatusRegClick(View view) {
		byte []writeData = new byte[1];
		byte []readData = new byte[1];
		int []returnLen = new int [1];
		int code = mSmartCardManager.AT45D041Cmd(
				Op_StatusRegRead, 
				0, 
				0, 
				0, 
				writeData, 
				1, 
				readData, 
				returnLen);
		if (code == 0)
			mText.setText(Utils.bytesToHexString(readData));
		else
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
	}

    private void init() {
        int errCode;
        String errMsg = null;
        try {
			//init AT45D041 mode
			mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_AT45D041);
            Log.d(TAG, "got slot count:" + mSlotCount);
        } catch (SmartPosException e) {
            mOpenBtn.setEnabled(false);
            errCode = e.getErrorCode();
            switch (errCode) {
                case SmartCardManager.SCR_ERR_INIT:
                    errMsg = "Reader init error!";
                    break;
            }
            Log.d(TAG, "init errCode:" + errCode + " " + errMsg);
            mText.setText("errCode: " + errCode + "  " + errMsg);
            mToast.showToast(R.string.smartcard_init_err);
        }
    }

    private void open() {
        Log.d(TAG, "open slot:" + mSlotSelected);
        mOpenBtn.setEnabled(false);
        mOpenTask = new OpenTask();
        mOpenTask.execute(this);
    }

    private void close() {
        mCloseBtn.setEnabled(false);
        mCloseTask = new CloseTask();
        mCloseTask.execute();
    }

	private void sendCmd(byte opCode) {
		int readLen=0,writeLen=0;
		byte []writeData = new byte[256];
		byte []readData = new byte[256];
		int []returnLen = new int[1];
		int code;
		String tmp = mEditPageNum.getText().toString();
		int addr = Integer.parseInt(tmp, 16);
		tmp = mEditPageNum.getText().toString();
		int pageNum = Integer.parseInt(tmp, 16);

		switch (opCode) {
			case Op_MainMRead:
			case Op_Buff1Read:
			case Op_Buff2Read:
				writeLen = 0;
				tmp = mEditLength.getText().toString();
				readLen = Integer.parseInt(tmp, 16);
				break;
			case Op_Buff1Write:
			case Op_Buff2Write:
				tmp = mEditWriteData.getText().toString();
				writeData = Utils.stringToBytes(tmp);
				writeLen = writeData.length;
				break;
			default :
				readLen = 0;
				writeLen = 0;
				break;
		}
		code = mSmartCardManager.AT45D041Cmd(
				opCode,
				pageNum,
				addr,
				writeLen,
				writeData,
				readLen,
				readData, 
				returnLen);

		if (code == 0) {
			switch (opCode) {
				case Op_MainMRead:
				case Op_Buff1Read:
				case Op_Buff2Read:
					mText.setText(Utils.bytesToHexString(readData));
					return;
			}
		} else {
			mText.setText("errCode: " + Integer.toHexString(code) + " " + SmartCardManager.errCode2String(code));
		}
	}

    private void setReaderSlotView() {
        final String[] arraySlot = new String[]{"slot:0", "Slot:1"};
        mSlotDialog = new AlertDialog.Builder(this);
        DialogInterface.OnClickListener Select = new DialogInterface.OnClickListener() {

            @Override
            public void onClick(DialogInterface dialog, int which) {
                mSlotSelected = (byte) which;
            }
        };

        DialogInterface.OnClickListener OkClick = new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int which) {
                open();
            }
        };

        mSlotDialog.setPositiveButton("OK", OkClick);
        mSlotDialog.setTitle("Select Slot Number");
        mSlotDialog.setSingleChoiceItems(arraySlot, 0, Select);
    }


    /**
     * @brief helper class for init smartcard reader
     */
    private class OpenTask extends AsyncTask<Context, Void, Boolean> {
        private int errCode;

		@Override 
		protected void onPreExecute() {
			mWaitProgress.setMessage("Opening...");
			mWaitProgress.show();
		}

        @Override
        protected Boolean doInBackground(Context... params) {
            if (isCancelled()) {
                return false;
            }
            try {
				//init AT45D041 mode
                mSlotCount = mSmartCardManager.init(getApplicationContext(), SmartCardManager.SCR_MODE_AT45D041);
                mSmartCardManager.selectSlot(mSlotSelected);
                Log.d(TAG, "Select slot:" + mSlotSelected);
                mSmartCardManager.powerOn();
                Log.d(TAG, "Power On");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            try {
                Message msg = new Message();
                msg.what = MSG_OPEN_RESULT;
                Bundle bundle = new Bundle();
                bundle.putBoolean(KEY_RESULT, result);
                if (result) {
                } else {
                    bundle.putInt(KEY_ERR_CODE, errCode);
                }
                msg.setData(bundle);
                mHandler.sendMessage(msg);
            } catch (Exception e) {
                Log.d(TAG, "open task err!");
            }
        }
    }

    /**
     * @brief helper class for deinit smartcard reader
     */
    private class CloseTask extends AsyncTask<Void, Void, Boolean> {
        int errCode;

        @Override
        protected Boolean doInBackground(Void... params) {
            if (isCancelled()) {
                return false;
            }
            try {
                mSmartCardManager.powerOff();
                Log.d(TAG, "Power Off");
                mSmartCardManager.deinit();
                Log.d(TAG, "Deinit");
            } catch (SmartPosException e) {
                mSmartCardManager.deinit();
                errCode = e.getErrorCode();
                return false;
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            Message msg = new Message();
            msg.what = MSG_CLOSE_RESULT;
            Bundle bundle = new Bundle();
            bundle.putBoolean(KEY_RESULT, result);
            if (!result) {
                bundle.putInt(KEY_ERR_CODE, errCode);
            }
            msg.setData(bundle);
            mHandler.sendMessage(msg);
        }
    }
}
