package com.paydevice.smartpos.demo;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import android.view.View;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TextView.OnEditorActionListener;

import com.paydevice.smartpos.sdk.serialport.SerialPort;

import java.io.File;
import java.io.IOException;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;

import java.util.Timer;
import java.util.TimerTask;
import java.util.List;
import java.util.ArrayList;
import java.lang.NullPointerException;

public class SerialPortActivity extends AppCompatActivity {

    private static final String TAG = "SerialPortActivity";

    private static final String DB9 = "/dev/db9";

    private static final String KEY_DATA = "key_data";
    private static final int MSG_READ_DATA = 0;
    private static final int TASK_RUNNING = 10;
    private static final int TASK_CANCEL = 11;

	private MyToast mToast;
    private TextView mReadText;

    private Timer readTimer;
    private TimerTask readTask;
    private int taskStatus = TASK_CANCEL;

    private List<String> baudrateList = new ArrayList<String>();
    private ArrayAdapter<String> baudrateAdapter;

    private int mBaudrate = 9600;

    private SerialPort mSerialPort;
    private OutputStream mOutputStream;
    private InputStream mInputStream;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setTitle(R.string.serialport);
		mToast = new MyToast(this);

        setContentView(R.layout.activity_serialport);
        Spinner mBaudrateList = (Spinner) findViewById(R.id.baudrate);
        mReadText = (TextView) findViewById(R.id.read);
        EditText mWriteText = (EditText) findViewById(R.id.write);

        mWriteText.setOnEditorActionListener(new OnEditorActionListener() {
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                int i;
                CharSequence t = v.getText();
                char[] text = new char[t.length()];
                for (i = 0; i < t.length(); i++) {
                    text[i] = t.charAt(i);
                }
                try {
                    Log.d(TAG, "write:" + new String(text));
                    mOutputStream.write(new String(text).getBytes());
                    mOutputStream.write('\n');
                } catch (NullPointerException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }
        });

        baudrateList.add("9600");
        baudrateList.add("19200");
        baudrateList.add("38400");
        baudrateList.add("57600");
        baudrateList.add("115200");
        baudrateAdapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, baudrateList);
        baudrateAdapter.setDropDownViewResource(android.R.layout.simple_list_item_activated_1);

        mBaudrateList.setAdapter(baudrateAdapter);
        mBaudrateList.setOnItemSelectedListener(new Spinner.OnItemSelectedListener() {
            public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                mBaudrate = Integer.parseInt(baudrateAdapter.getItem(arg2));
				openSerialPort();
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
        mBaudrateList.setOnTouchListener(new Spinner.OnTouchListener() {
            public boolean onTouch(View v, MotionEvent event) {
                /* TODO Auto-generated method stub */
                return false;
            }
        });
        mBaudrateList.setOnFocusChangeListener(new Spinner.OnFocusChangeListener() {
            public void onFocusChange(View v, boolean hasFocus) {
                /* TODO Auto-generated method stub */
            }
        });
    }

    @Override
    public void onResume() {
        //openSerialPort();
        super.onResume();
    }

    @Override
    public void onPause() {
		//need release serialport
		mToast.cancel();
        closeSerialPort();
        super.onPause();
    }

	private void openSerialPort() {
		if (mSerialPort == null) {
			try {
				mSerialPort = new SerialPort(new File(DB9), mBaudrate);
				mOutputStream = mSerialPort.getOutputStream();
				mInputStream = mSerialPort.getInputStream();
				Log.d(TAG, "open DB9 at:" + mBaudrate + "bps");
				startRead();
			} catch (SecurityException e) {
				Log.d(TAG, "open DB9 fail:SecurityException");
				mToast.showToast("open DB9 fail:SecurityException");
			} catch (IOException e) {
				Log.d(TAG, "open DB9 fail:IOException");
				mToast.showToast("open DB9 fail:IOException");
			} catch (InvalidParameterException e) {
				Log.d(TAG, "open DB9 fail:InvalidParameterException");
				mToast.showToast("open DB9 fail:InvalidParameterException");
			}
		}
	}

    private void closeSerialPort() {
        if (mSerialPort != null) {
            mSerialPort.close();
            mSerialPort = null;
			mOutputStream = null;
			mInputStream = null;
            Log.d(TAG, "close DB9");
        }
        cleanTask();
    }

    private void cleanTask() {
        taskStatus = TASK_CANCEL;
        if (readTask != null) {
			Log.d(TAG, "---clean read task---");
            readTask.cancel();
            readTask = null;
        }
        if (readTimer != null) {
            readTimer.cancel();
            readTimer.purge();
            readTimer = null;
        }
    }

    public Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            if (msg.what == MSG_READ_DATA) {
                String data = msg.getData().getString(KEY_DATA);
                if (data != null) {
                    mReadText.setText(data);
                }
            }
        }
    };

    public synchronized int getTaskStatus() {
        return taskStatus;
    }

    private void startRead() {
        mReadText.setText("");
        cleanTask();
        if (readTimer == null) {
            readTimer = new Timer();
        }
        if (readTask != null) {
            readTask.cancel();
            readTask = null;
        }
        try {
            int oldCount = mInputStream.available();
            if (oldCount > 0)
                mInputStream.skip(oldCount);
            Log.d(TAG, "discard bytes " + oldCount);
        } catch (EOFException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        readTask = new TimerTask() {
            public void run() {
                int status = getTaskStatus();
                switch (status) {
                    case TASK_RUNNING:
                        Bundle bundle = new Bundle();
                        Message msg = new Message();
                        msg.what = MSG_READ_DATA;
                        try {
                            if (mInputStream == null) {
                                Log.e(TAG, "mInputStream is null");
                                break;
                            }
                            byte[] buffer = new byte[128];
                            if (mInputStream.available() > 0) {
                                int size = mInputStream.read(buffer);
                                //Log.d(TAG,"read:\n"+new String(buffer,0, size));
                                //bundle.putString(KEY_DATA, Utils.bytesToHexString(buffer));
                                bundle.putString(KEY_DATA, new String(buffer, 0, size));
                                msg.setData(bundle);
                                mHandler.sendMessage(msg);
                            }
                        } catch (EOFException e) {
                            e.printStackTrace();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;

                    case TASK_CANCEL:
                        Log.d(TAG, "---read task cancel---");
                        cleanTask();
                        break;
                }
            }
        };
        taskStatus = TASK_RUNNING;
        readTimer.schedule(readTask, 0, 50);
    }
}
