package com.paydevice.smartpos.demo;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.widget.TextView;

import com.paydevice.smartpos.sdk.SmartPosException;


public class ScannerActivity extends AppCompatActivity {

    private static final String TAG = "ScannerActivity";

	private Scanner mScanner;
	private TextView mScannerText;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setTitle(R.string.scanner);
        setContentView(R.layout.activity_scanner);

        mScannerText = (TextView) findViewById(R.id.text_result);
		initScanner();
    }

    @Override
	protected void onResume() {
		super.onResume();
	}

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
	public boolean dispatchKeyEvent(KeyEvent event) {
		if (event.getDeviceId() > 0 && !event.isSystem())
			return mScanner.handleKey(event);
		else
			return super.dispatchKeyEvent(event);
	}

	private void initScanner() {
		mScanner = new Scanner(new Scanner.onScanResultListener() {
			public void onScanResult(String result) {
				mScannerText.setText(result);
			}
		});
	}
}
