/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.smartcard;

import amlib.ccid.Reader;
import amlib.ccid.Reader4428;
import amlib.ccid.Reader4442;
import amlib.ccid.Reader6636;
import amlib.ccid.ReaderAT24C;
import amlib.ccid.ReaderAT45D041;
import amlib.ccid.ReaderAT88SC102;
import amlib.ccid.ReaderAT88SC1608;
import amlib.ccid.SCError;
import amlib.hw.HWType;
import amlib.hw.HardwareInterface;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.paydevice.smartpos.sdk.SmartPosException;
import java.util.HashMap;

public class SmartCardManager {
    private static final String TAG = "SmartCardManager";
    private static final String ACTION_USB_PERMISSION = "com.paydevice.smartpos.sdk.smartcard.USB_PERMISSION";
    private static boolean initFlag = false;
    public static final int SCR_ERR_INIT = 241;
    public static final int SCR_ERR_DEINIT = 242;
    public static final int SCR_ERR_NO_INIT = 243;
    public static final int SCR_ERR_ALREADY_INIT = 244;
    public static final int SCR_ERR_PARAM = 245;
    public static final int SCR_ERR_CODE_SUCCESSFUL = 0;
    public static final int SCR_ERR_CODE_TRANSMIT_ERROR = 1;
    public static final int SCR_ERR_CODE_CMD_FAIL = 2;
    public static final int SCR_ERR_CODE_CMD_BUSY = 3;
    public static final int SCR_ERR_CODE_NOT_SUPPORT = 4;
    public static final int SCR_ERR_CODE_NO_CARD = 5;
    public static final int SCR_ERR_CODE_MEM_ERROR = 6;
    public static final int SCR_ERR_CODE_TIMEOUT = 7;
    public static final int SCR_ERR_CODE_INVALID_PARAMETER = 8;
    public static final int SCR_ERR_CODE_NOT_INITIALIZED = 9;
    public static final int SCR_ERR_CODE_PBOC_FAIL = 16;
    public static final int SCR_ERR_CODE_CARD_INACTIVE = 17;
    public static final int SCR_ERR_CODE_CARD_LOCKED = 18;
    public static final int SCR_ERR_CODE_DEV_ERR = 19;
    public static final int SCR_MODE_ISO7816 = 1;
    public static final int SCR_MODE_AT24C = 2;
    public static final int SCR_MODE_SLE4428 = 3;
    public static final int SCR_MODE_SLE4442 = 4;
    public static final int SCR_MODE_AT88SC1608 = 5;
    public static final int SCR_MODE_AT45D041 = 7;
    public static final int SCR_MODE_SLE6636 = 8;
    public static final int SCR_MODE_AT88SC102 = 9;
    public static final int PROTOCOL_T0 = 1;
    public static final int PROTOCOL_T1 = 2;
    public static final int PROTOCOL_NA = 3;
    private Reader mISO7816Reader;
    private ReaderAT24C mAT24CReader;
    private Reader4428 mSLE4428Reader;
    private Reader4442 mSLE4442Reader;
    private ReaderAT88SC1608 mAT88SC1608Reader;
    private ReaderAT45D041 mAT45D01Reader;
    private Reader6636 mSLE6636Reader;
    private ReaderAT88SC102 mAT88SC102Reader;
    private HardwareInterface mHwIf;
    private UsbDevice mUsbDev;
    private UsbManager mManager;
    private int mCardMode = 1;

    public int init(Context ctx) throws SmartPosException {
        return this.init(ctx, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int init(Context ctx, int mode) throws SmartPosException {
        int slotCount = 1;
        boolean bFound = false;
        this.mCardMode = mode;
        if (initFlag) throw new SmartPosException(244);
        Log.d((String)TAG, (String)"amlib ver:v1.0.27.0");
        if (ctx == null) {
            throw new SmartPosException(245);
        }
        UsbDevice device2 = null;
        try {
            this.mHwIf = new HardwareInterface(HWType.eUSB, ctx);
            this.mManager = (UsbManager)ctx.getSystemService("usb");
            HashMap deviceList = this.mManager.getDeviceList();
            for (UsbDevice device2 : deviceList.values()) {
                if (!this.isAlcorReader(device2)) continue;
                if (!this.mManager.hasPermission(device2)) {
                    Log.d((String)TAG, (String)"no usb permission");
                    break;
                }
                this.mUsbDev = device2;
                bFound = true;
                break;
            }
            if (!bFound) throw new SmartPosException(241);
            if (this.mHwIf.Init(this.mManager, this.mUsbDev)) {
                switch (this.mCardMode) {
                    case 1: {
                        this.mISO7816Reader = new Reader(this.mHwIf);
                        break;
                    }
                    case 2: {
                        this.mAT24CReader = new ReaderAT24C(this.mHwIf);
                        break;
                    }
                    case 3: {
                        this.mSLE4428Reader = new Reader4428(this.mHwIf);
                        break;
                    }
                    case 4: {
                        this.mSLE4442Reader = new Reader4442(this.mHwIf);
                        break;
                    }
                    case 5: {
                        this.mAT88SC1608Reader = new ReaderAT88SC1608(this.mHwIf);
                        break;
                    }
                    case 7: {
                        this.mAT45D01Reader = new ReaderAT45D041(this.mHwIf);
                        break;
                    }
                    case 8: {
                        this.mSLE6636Reader = new Reader6636(this.mHwIf);
                        break;
                    }
                    case 9: {
                        this.mAT88SC102Reader = new ReaderAT88SC102(this.mHwIf);
                    }
                }
            } else {
                if (this.mHwIf == null) throw new SmartPosException(241);
                this.mHwIf.Close();
                this.mHwIf = null;
                throw new SmartPosException(241);
            }
            if (this.mUsbDev.getProductId() == 38178 || this.mUsbDev.getProductId() == 38181 || this.mUsbDev.getProductId() == 38182) {
                slotCount = 2;
            }
        }
        catch (Exception e2) {
            Log.d((String)TAG, (String)("init err:" + e2.getMessage()));
            throw new SmartPosException(241);
        }
        initFlag = true;
        return slotCount;
    }

    public void deinit() {
        try {
            int status = 0;
            do {
                switch (this.mCardMode) {
                    case 1: {
                        status = this.mISO7816Reader.close();
                        break;
                    }
                    case 2: {
                        status = this.mAT24CReader.close();
                        break;
                    }
                    case 3: {
                        status = this.mSLE4428Reader.close();
                        break;
                    }
                    case 4: {
                        status = this.mSLE4442Reader.close();
                        break;
                    }
                    case 5: {
                        status = this.mAT88SC1608Reader.close();
                        break;
                    }
                    case 7: {
                        status = this.mAT45D01Reader.close();
                        break;
                    }
                    case 8: {
                        status = this.mSLE6636Reader.close();
                        break;
                    }
                    case 9: {
                        status = this.mAT88SC102Reader.close();
                    }
                }
            } while (status == 3);
            if (this.mHwIf != null) {
                this.mHwIf.Close();
                this.mHwIf = null;
            }
        }
        catch (Exception e2) {
            Log.d((String)TAG, (String)("deinit err:" + e2.getMessage()));
        }
        initFlag = false;
    }

    public void selectSlot(int slot) throws SmartPosException {
        if (!initFlag) {
            throw new SmartPosException(243);
        }
        if (slot < 0 || slot > 1) {
            throw new SmartPosException(245);
        }
        try {
            switch (this.mCardMode) {
                default: {
                    this.mISO7816Reader.setSlot((byte)slot);
                    this.mISO7816Reader.open();
                    break;
                }
                case 2: {
                    this.mAT24CReader.setSlot((byte)slot);
                    this.mAT24CReader.open();
                    break;
                }
                case 3: {
                    this.mSLE4428Reader.setSlot((byte)slot);
                    this.mSLE4428Reader.open();
                    break;
                }
                case 4: {
                    this.mSLE4442Reader.setSlot((byte)slot);
                    this.mSLE4442Reader.open();
                    break;
                }
                case 5: {
                    this.mAT88SC1608Reader.setSlot((byte)slot);
                    this.mAT88SC1608Reader.open();
                    break;
                }
                case 7: {
                    this.mAT45D01Reader.setSlot((byte)slot);
                    this.mAT45D01Reader.open();
                    break;
                }
                case 8: {
                    this.mSLE6636Reader.setSlot((byte)slot);
                    this.mSLE6636Reader.open();
                    break;
                }
                case 9: {
                    this.mAT88SC102Reader.setSlot((byte)slot);
                    this.mAT88SC102Reader.open();
                    break;
                }
            }
        }
        catch (NullPointerException e2) {
            Log.d((String)TAG, (String)("selectSlot err:" + e2.getMessage()));
        }
    }

    public void powerOn() throws SmartPosException {
        int err = 9;
        if (!initFlag) {
            throw new SmartPosException(243);
        }
        if (this.getSlotStatus() == 5) {
            throw new SmartPosException(5);
        }
        try {
            switch (this.mCardMode) {
                case 1: {
                    err = this.mISO7816Reader.setPower(1);
                    break;
                }
                case 2: {
                    err = this.mAT24CReader.setPower(1);
                    break;
                }
                case 3: {
                    err = this.mSLE4428Reader.setPower(1);
                    break;
                }
                case 4: {
                    err = this.mSLE4442Reader.setPower(1);
                    break;
                }
                case 5: {
                    err = this.mAT88SC1608Reader.setPower(1);
                    break;
                }
                case 7: {
                    err = this.mAT45D01Reader.setPower(1);
                    break;
                }
                case 8: {
                    err = this.mSLE6636Reader.setPower(1);
                    break;
                }
                case 9: {
                    err = this.mAT88SC102Reader.setPower(1);
                }
            }
        }
        catch (NullPointerException e2) {
            Log.d((String)TAG, (String)("powerOn err:" + e2.getMessage()));
        }
        if (err != 0) {
            throw new SmartPosException(err);
        }
    }

    public void powerOff() throws SmartPosException {
        int err = 9;
        if (!initFlag) {
            throw new SmartPosException(243);
        }
        if (this.getSlotStatus() == 5) {
            throw new SmartPosException(5);
        }
        try {
            switch (this.mCardMode) {
                case 1: {
                    err = this.mISO7816Reader.setPower(-1);
                    break;
                }
                case 2: {
                    err = this.mAT24CReader.setPower(-1);
                    break;
                }
                case 3: {
                    err = this.mSLE4428Reader.setPower(-1);
                    break;
                }
                case 4: {
                    err = this.mSLE4442Reader.setPower(-1);
                    break;
                }
                case 5: {
                    err = this.mAT88SC1608Reader.setPower(-1);
                    break;
                }
                case 7: {
                    err = this.mAT45D01Reader.setPower(-1);
                    break;
                }
                case 8: {
                    err = this.mSLE6636Reader.setPower(-1);
                    break;
                }
                case 9: {
                    err = this.mAT88SC102Reader.setPower(-1);
                }
            }
        }
        catch (NullPointerException e2) {
            Log.d((String)TAG, (String)("powerOff err:" + e2.getMessage()));
        }
        if (err != 0) {
            throw new SmartPosException(err);
        }
    }

    public byte[] getATR() throws SmartPosException {
        if (!initFlag) {
            throw new SmartPosException(243);
        }
        byte[] atr = null;
        try {
            switch (this.mCardMode) {
                case 1: {
                    atr = this.mISO7816Reader.getAtr();
                    break;
                }
                case 2: {
                    atr = this.mAT24CReader.getAtr();
                    break;
                }
                case 3: {
                    atr = this.mSLE4428Reader.getAtr();
                    break;
                }
                case 4: {
                    atr = this.mSLE4442Reader.getAtr();
                    break;
                }
                case 5: {
                    atr = this.mAT88SC1608Reader.getAtr();
                    break;
                }
                case 7: {
                    atr = this.mAT45D01Reader.getAtr();
                    break;
                }
                case 8: {
                    atr = this.mSLE6636Reader.getAtr();
                    break;
                }
                case 9: {
                    atr = this.mAT88SC102Reader.getAtr();
                }
            }
        }
        catch (Exception e2) {
            Log.d((String)TAG, (String)("getATR err:" + e2.getMessage()));
        }
        return atr;
    }

    public int getProtocol() throws SmartPosException {
        int ret = 3;
        if (!initFlag) {
            throw new SmartPosException(243);
        }
        if (this.mISO7816Reader != null) {
            byte[] proto = new byte[1];
            int err = this.mISO7816Reader.getProtocol(proto);
            if (err != 0) {
                Log.e((String)TAG, (String)("getProtocol fail: " + Integer.toString(err) + "(" + Integer.toHexString(this.mISO7816Reader.getCmdFailCode()) + ")"));
                throw new SmartPosException(err);
            }
            ret = proto[0];
        }
        return ret;
    }

    public byte[] getSN() throws SmartPosException {
        if (!initFlag) {
            throw new SmartPosException(243);
        }
        byte[] sn = null;
        if (this.mISO7816Reader != null) {
            byte[] pLen = new byte[]{32};
            byte[] pSN = new byte[pLen[0]];
            int err = this.mISO7816Reader.getSN(pSN, pLen);
            if (err != 0) {
                Log.d((String)TAG, (String)("getSN fail: (" + Integer.toHexString(this.mISO7816Reader.getCmdFailCode()) + ")"));
                throw new SmartPosException(err);
            }
            sn = new byte[pLen[0]];
            System.arraycopy(pSN, 0, sn, 0, sn.length);
        }
        return sn;
    }

    public byte[] sendAPDU(byte[] apdu) throws SmartPosException {
        if (!initFlag) {
            throw new SmartPosException(243);
        }
        byte[] ack = null;
        if (this.mISO7816Reader != null) {
            byte[] ackBuf = new byte[300];
            int[] ackLen = new int[1];
            int err = this.mISO7816Reader.transmit(apdu, apdu.length, ackBuf, ackLen);
            if (err != 0) {
                Log.e((String)TAG, (String)("sendAPDU fail: " + Integer.toString(err) + "(" + Integer.toHexString(this.mISO7816Reader.getCmdFailCode()) + ")"));
                throw new SmartPosException(err);
            }
            ack = new byte[ackLen[0]];
            System.arraycopy(ackBuf, 0, ack, 0, ack.length);
        }
        return ack;
    }

    public void sendAPDU(byte[] apdu, byte[] respone, int[] responeLen) throws SmartPosException {
        int err;
        if (!initFlag) {
            throw new SmartPosException(243);
        }
        if (this.mISO7816Reader != null && (err = this.mISO7816Reader.transmit(apdu, apdu.length, respone, responeLen)) != 0) {
            Log.e((String)TAG, (String)("sendAPDU fail: " + Integer.toString(err) + "(" + Integer.toHexString(this.mISO7816Reader.getCmdFailCode()) + ")"));
            throw new SmartPosException(err);
        }
    }

    public static String errCode2String(int errCode) {
        return SCError.errorCode2String(errCode);
    }

    public int AT24CSeriesCmdRead(int intStartAddr, byte bCardType, int intReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mAT24CReader != null) {
            ret = this.mAT24CReader.AT24CSeriesCmd_Read(intStartAddr, bCardType, intReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int AT24CSeriesCmdWrite(int intStartAddr, byte bCardType, int intWordPageSize, int intWriteLen, byte[] pWriteData) {
        int ret = -1;
        if (this.mAT24CReader != null) {
            ret = this.mAT24CReader.AT24CSeriesCmd_Write(intStartAddr, bCardType, intWordPageSize, intWriteLen, pWriteData);
        }
        return ret;
    }

    public int AT24CxxCmdRead(byte bDeviceAddress, int intStartAddr, int intReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mAT24CReader != null) {
            ret = this.mAT24CReader.AT24CxxCmd_Read(bDeviceAddress, intStartAddr, intReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int AT24CxxCmdWrite(int intStartAddr, int intWordPageSize, int intWriteLen, byte[] pWriteData) {
        int ret = -1;
        if (this.mAT24CReader != null) {
            ret = this.mAT24CReader.AT24CxxCmd_Write(intStartAddr, intWordPageSize, intWriteLen, pWriteData);
        }
        return ret;
    }

    public int AT45D041Cmd(byte OPcode, int PageNo, int intStartAddr, int intWriteLen, byte[] pWriteData, int intReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mAT45D01Reader != null) {
            ret = this.mAT45D01Reader.AT45D041Cmd(OPcode, PageNo, intStartAddr, intWriteLen, pWriteData, intReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int AT88SC1608CmdInitializeAuthentication(byte[] pbHostRand) {
        int ret = -1;
        if (this.mAT88SC1608Reader != null) {
            ret = this.mAT88SC1608Reader.AT88SC1608Cmd_InitializeAuthentication(pbHostRand);
        }
        return ret;
    }

    public int AT88SC1608CmdReadConfigurationZone(byte bAddress, byte bReadLen, byte[] pReadBuffer, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mAT88SC1608Reader != null) {
            ret = this.mAT88SC1608Reader.AT88SC1608Cmd_ReadConfigurationZone(bAddress, bReadLen, pReadBuffer, pIntReturnLen);
        }
        return ret;
    }

    public int AT88SC1608CmdReadUserZone(byte bAddress, byte bReadLen, byte[] pReadBuffer, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mAT88SC1608Reader != null) {
            ret = this.mAT88SC1608Reader.AT88SC1608Cmd_ReadUserZone(bAddress, bReadLen, pReadBuffer, pIntReturnLen);
        }
        return ret;
    }

    public int AT88SC1608CmdSetUserZoneAddress(byte bAddress) {
        int ret = -1;
        if (this.mAT88SC1608Reader != null) {
            ret = this.mAT88SC1608Reader.AT88SC1608Cmd_SetUserZoneAddress(bAddress);
        }
        return ret;
    }

    public int AT88SC1608CmdVerifyAuthentication(byte[] pbHostChallenge) {
        int ret = -1;
        if (this.mAT88SC1608Reader != null) {
            ret = this.mAT88SC1608Reader.AT88SC1608Cmd_VerifyAuthentication(pbHostChallenge);
        }
        return ret;
    }

    public int AT88SC1608CmdVerifyPassword(byte bZoneNo, boolean bIsReadAccess, byte bPW1, byte bPW2, byte bPW3) {
        int ret = -1;
        if (this.mAT88SC1608Reader != null) {
            ret = this.mAT88SC1608Reader.AT88SC1608Cmd_VerifyPassword(bZoneNo, bIsReadAccess, bPW1, bPW2, bPW3);
        }
        return ret;
    }

    public int AT88SC1608CmdWriteConfigurationZone(byte bAddress, byte bWriteLen, byte[] pWriteBuffer) {
        int ret = -1;
        if (this.mAT88SC1608Reader != null) {
            ret = this.mAT88SC1608Reader.AT88SC1608Cmd_WriteConfigurationZone(bAddress, bWriteLen, pWriteBuffer);
        }
        return ret;
    }

    public int AT88SC1608CmdWriteUserZone(byte bAddress, byte bWriteLen, byte[] pWriteBuffer) {
        int ret = -1;
        if (this.mAT88SC1608Reader != null) {
            ret = this.mAT88SC1608Reader.AT88SC1608Cmd_WriteUserZone(bAddress, bWriteLen, pWriteBuffer);
        }
        return ret;
    }

    public int AT88SC102CmdOpBitGetAddr(int[] pIntCurBitAddr) {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpBitGetAddr(pIntCurBitAddr);
        }
        return ret;
    }

    public int AT88SC102CmdOpBitsGotoAddr(int intTargetAddr) {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpBitsGotoAddr(intTargetAddr);
        }
        return ret;
    }

    public int AT88SC102CmdOpBitsIncAddr(int intBitsIncAddr) {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpBitsIncAddr(intBitsIncAddr);
        }
        return ret;
    }

    public int AT88SC102CmdOpBitsRead(int intReadLen, byte[] pDataBuffer) {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpBitsRead(intReadLen, pDataBuffer);
        }
        return ret;
    }

    public int AT88SC102CmdOpBytesComp(int intCompLen, byte[] pDataBuffer) {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpBytesComp(intCompLen, pDataBuffer);
        }
        return ret;
    }

    public int AT88SC102CmdOpBytesIncAddr(int intBytesIncAddr) {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpBytesIncAddr(intBytesIncAddr);
        }
        return ret;
    }

    public int AT88SC102CmdOpBytesRead(int intReadLen, byte[] pDataBuffer) {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpBytesRead(intReadLen, pDataBuffer);
        }
        return ret;
    }

    public int AT88SC102CmdOpBytesWrite(int intWriteLen, byte[] pDataBuffer) {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpBytesWrite(intWriteLen, pDataBuffer);
        }
        return ret;
    }

    public int AT88SC102CmdOpReset() {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpReset();
        }
        return ret;
    }

    public int AT88SC102CmdOpSingleBitErase() {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpSingleBitErase();
        }
        return ret;
    }

    public int AT88SC102CmdOpSingleBitWrite() {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpSingleBitWrite();
        }
        return ret;
    }

    public int AT88SC102CmdOpStandby() {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_OpStandby();
        }
        return ret;
    }

    public int AT88SC102CmdSetFusPinHigh() {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_SetFusPinHigh();
        }
        return ret;
    }

    public int AT88SC102CmdSetFusPinLow() {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_SetFusPinLow();
        }
        return ret;
    }

    public int AT88SC102CmdSetRstPinHigh() {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_SetRstPinHigh();
        }
        return ret;
    }

    public int AT88SC102CmdSetRstPinLow() {
        int ret = -1;
        if (this.mAT88SC102Reader != null) {
            ret = this.mAT88SC102Reader.AT88SC102Cmd_SetRstPinLow();
        }
        return ret;
    }

    public int SLE4428CmdRead8Bits(int address, int intReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE4428Reader != null) {
            ret = this.mSLE4428Reader.SLE4428Cmd_Read8Bits(address, intReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int SLE4428CmdRead9Bits(int address, int intReadLen, byte[] pReadData, byte[] pReadPB, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE4428Reader != null) {
            ret = this.mSLE4428Reader.SLE4428Cmd_Read9Bits(address, intReadLen, pReadData, pReadPB, pIntReturnLen);
        }
        return ret;
    }

    public int SLE4428CmdVerify1stPSC(byte data) {
        int ret = -1;
        if (this.mSLE4428Reader != null) {
            ret = this.mSLE4428Reader.SLE4428Cmd_Verify1stPSC(data);
        }
        return ret;
    }

    public int SLE4428CmdVerify2ndPSC(byte data) {
        int ret = -1;
        if (this.mSLE4428Reader != null) {
            ret = this.mSLE4428Reader.SLE4428Cmd_Verify2ndPSC(data);
        }
        return ret;
    }

    public int SLE4428CmdVerifyPSCAndEraseErrorCounter(byte b1stPsc, byte b2ndPsc, int[] pIntErrorReason) {
        int ret = -1;
        if (this.mSLE4428Reader != null) {
            ret = this.mSLE4428Reader.SLE4428Cmd_VerifyPSCAndEraseErrorCounter(b1stPsc, b2ndPsc, pIntErrorReason);
        }
        return ret;
    }

    public int SLE4428CmdWriteEraseWithoutPB(int address, byte data) {
        int ret = -1;
        if (this.mSLE4428Reader != null) {
            ret = this.mSLE4428Reader.SLE4428Cmd_WriteEraseWithoutPB(address, data);
        }
        return ret;
    }

    public int SLE4428CmdWriteEraseWithPB(int address, byte data) {
        int ret = -1;
        if (this.mSLE4428Reader != null) {
            ret = this.mSLE4428Reader.SLE4428Cmd_WriteEraseWithPB(address, data);
        }
        return ret;
    }

    public int SLE4428CmdWriteErrorCounter(byte data) {
        int ret = -1;
        if (this.mSLE4428Reader != null) {
            ret = this.mSLE4428Reader.SLE4428Cmd_WriteErrorCounter(data);
        }
        return ret;
    }

    public int SLE4428CmdWritePBWithDataComparison(int address, byte data) {
        int ret = -1;
        if (this.mSLE4428Reader != null) {
            ret = this.mSLE4428Reader.SLE4428Cmd_WritePBWithDataComparison(address, data);
        }
        return ret;
    }

    public int SLE4442CmdCompareVerificationData(byte bAddress, byte bData) {
        int ret = -1;
        if (this.mSLE4442Reader != null) {
            ret = this.mSLE4442Reader.SLE4442Cmd_CompareVerificationData(bAddress, bData);
        }
        return ret;
    }

    public int SLE4442CmdReadMainMemory(byte bAddress, byte bReadLen, byte[] pReadData, int[] pReturnLen) {
        int ret = -1;
        if (this.mSLE4442Reader != null) {
            ret = this.mSLE4442Reader.SLE4442Cmd_ReadMainMemory(bAddress, bReadLen, pReadData, pReturnLen);
        }
        return ret;
    }

    public int SLE4442CmdReadProtectionMemory(byte bReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE4442Reader != null) {
            ret = this.mSLE4442Reader.SLE4442Cmd_ReadProtectionMemory(bReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int SLE4442CmdReadSecurityMemory(byte bReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE4442Reader != null) {
            ret = this.mSLE4442Reader.SLE4442Cmd_ReadSecurityMemory(bReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int SLE4442CmdUpdateMainMemory(byte bAddress, byte bData) {
        int ret = -1;
        if (this.mSLE4442Reader != null) {
            ret = this.mSLE4442Reader.SLE4442Cmd_UpdateMainMemory(bAddress, bData);
        }
        return ret;
    }

    public int SLE4442CmdUpdateSecurityMemory(byte bAddress, byte bData) {
        int ret = -1;
        if (this.mSLE4442Reader != null) {
            ret = this.mSLE4442Reader.SLE4442Cmd_UpdateSecurityMemory(bAddress, bData);
        }
        return ret;
    }

    public int SLE4442CmdVerify(int intPinLen, byte[] pPinData) {
        int ret = -1;
        if (this.mSLE4442Reader != null) {
            ret = this.mSLE4442Reader.SLE4442Cmd_Verify(intPinLen, pPinData);
        }
        return ret;
    }

    public int SLE4442CmdWriteProtectionMemory(byte bAddress, byte bData) {
        int ret = -1;
        if (this.mSLE4442Reader != null) {
            ret = this.mSLE4442Reader.SLE4442Cmd_WriteProtectionMemory(bAddress, bData);
        }
        return ret;
    }

    public int SLE6636CmdAuthentication(byte bKeyNo, byte bClock, byte bWriteLen, byte[] pWChallengeBuf, byte bReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE6636Reader != null) {
            ret = this.mSLE6636Reader.SLE6636Cmd_Authentication(bKeyNo, bClock, bWriteLen, pWChallengeBuf, bReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int SLE6636CmdReadCounters(byte bReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE6636Reader != null) {
            ret = this.mSLE6636Reader.SLE6636Cmd_ReadCounters(bReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int SLE6636CmdReadMemory(byte bAddress, byte bReadMEMLen, byte bReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE6636Reader != null) {
            ret = this.mSLE6636Reader.SLE6636Cmd_ReadMemory(bAddress, bReadMEMLen, bReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int SLE6636CmdReload(byte bAddress, byte bReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE6636Reader != null) {
            ret = this.mSLE6636Reader.SLE6636Cmd_Reload(bAddress, bReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int SLE6636CmdVerification(byte bTC1, byte bTC2, byte bTC3, byte bReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE6636Reader != null) {
            ret = this.mSLE6636Reader.SLE6636Cmd_Verification(bTC1, bTC2, bTC3, bReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int SLE6636CmdWriteCounter(byte bAddress, byte bWriteData, byte bReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE6636Reader != null) {
            ret = this.mSLE6636Reader.SLE6636Cmd_WriteCounter(bAddress, bWriteData, bReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    public int SLE6636CmdWriteMemory(int intApduLen, byte bAddress, byte bWriteLen, byte[] pWriteBuffer, byte bReadLen, byte[] pReadData, int[] pIntReturnLen) {
        int ret = -1;
        if (this.mSLE6636Reader != null) {
            ret = this.mSLE6636Reader.SLE6636Cmd_WriteMemory(intApduLen, bAddress, bWriteLen, pWriteBuffer, bReadLen, pReadData, pIntReturnLen);
        }
        return ret;
    }

    private int getSlotStatus() {
        int ret = 5;
        byte[] pCardStatus = new byte[1];
        try {
            switch (this.mCardMode) {
                case 1: {
                    ret = this.mISO7816Reader.getCardStatus(pCardStatus);
                    break;
                }
                case 2: {
                    ret = this.mAT24CReader.getCardStatus(pCardStatus);
                    break;
                }
                case 3: {
                    ret = this.mSLE4428Reader.getCardStatus(pCardStatus);
                    break;
                }
                case 4: {
                    ret = this.mSLE4442Reader.getCardStatus(pCardStatus);
                    break;
                }
                case 5: {
                    ret = this.mAT88SC1608Reader.getCardStatus(pCardStatus);
                    break;
                }
                case 7: {
                    ret = this.mAT45D01Reader.getCardStatus(pCardStatus);
                    break;
                }
                case 8: {
                    ret = this.mSLE6636Reader.getCardStatus(pCardStatus);
                    break;
                }
                case 9: {
                    ret = this.mAT88SC102Reader.getCardStatus(pCardStatus);
                }
            }
            if (ret == 0) {
                ret = pCardStatus[0] == 2 ? 5 : (pCardStatus[0] == 1 ? 17 : 0);
            }
        }
        catch (Exception e2) {
            Log.d((String)TAG, (String)("getSlotStatus err:" + e2.getMessage()));
        }
        return ret;
    }

    private boolean isAlcorReader(UsbDevice udev) {
        return udev.getVendorId() == 1423 && (udev.getProductId() == 38208 || udev.getProductId() == 38240 || udev.getProductId() == 38176 || udev.getProductId() == 38178 || udev.getProductId() == 38181 || udev.getProductId() == 38182);
    }
}

