/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.magneticcard;

import com.paydevice.smartpos.sdk.DeviceNative;
import com.paydevice.smartpos.sdk.SmartPosException;

public class MagneticCardManager {
    private static final String TAG = "MagneticCardManager";
    private static boolean initFlag = false;
    public static final int MCR_TYPE_UART = 0;
    public static final int MCR_TYPE_SPI = 1;
    public static final int MCR_ERR_INIT = 1;
    public static final int MCR_ERR_DEINIT = 2;
    public static final int MCR_ERR_NO_INIT = 3;
    public static final int MCR_ERR_ALREADY_INIT = 4;
    public static final int MCR_ERR_PARAM = 5;
    public static final int MCR_TRACK_ID1 = 1;
    public static final int MCR_TRACK_ID2 = 2;
    public static final int MCR_TRACK_ID3 = 3;
    public static final int MCR_ERR_CODE_PREAMBLE = 81;
    public static final int MCR_ERR_CODE_POSTAMBLE = 82;
    public static final int MCR_ERR_CODE_LRC = 83;
    public static final int MCR_ERR_CODE_PARITY = 84;
    public static final int MCR_ERR_CODE_BLANK_TRACK = 85;
    public static final int MCR_ERR_CODE_STX_ETX = 97;
    public static final int MCR_ERR_CODE_CLASS_FUNCTION = 98;
    public static final int MCR_ERR_CODE_BBC = 99;
    public static final int MCR_ERR_CODE_LENGTH = 100;
    public static final int MCR_ERR_CODE_NO_DATA = 101;
    public static final int MCR_ERR_CODE_OTP_WRITE_FULL = 113;
    public static final int MCR_ERR_CODE_OTP_WRITE = 114;
    public static final int MCR_ERR_CODE_OTP_CRC = 115;
    public static final int MCR_ERR_CODE_OTP_EMPTY = 116;
    public static final int MCR_SWIPE_CARD_PRESENT = 184;

    public void init() throws SmartPosException {
        if (!initFlag) {
            if (DeviceNative.nativeMcrInit() < 0) {
                throw new SmartPosException(1);
            }
        } else {
            throw new SmartPosException(4);
        }
        initFlag = true;
    }

    public void deinit() {
        DeviceNative.nativeMcrDeInit();
        initFlag = false;
    }

    public int query() throws SmartPosException {
        if (initFlag) {
            return DeviceNative.nativeMcrQuery();
        }
        throw new SmartPosException(3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getTrack(int trackId) throws SmartPosException {
        if (!initFlag) throw new SmartPosException(3);
        if (trackId <= 0 || trackId >= 4) throw new SmartPosException(5);
        byte[] tmp = new byte[128];
        int len = DeviceNative.nativeMcrGetTrack(trackId, tmp);
        if (len <= 0) return null;
        byte[] data = new byte[len];
        System.arraycopy(tmp, 0, data, 0, len);
        return data;
    }

    public int getInterfaceType() throws SmartPosException {
        if (initFlag) {
            return DeviceNative.nativeMcrGetType();
        }
        throw new SmartPosException(3);
    }

    static {
        try {
            System.loadLibrary("paydevice-smartpos");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

