/*
 * Decompiled with CFR 0.152.
 */
package com.paydevice.smartpos.sdk.cashdrawer;

import android.os.SystemProperties;
import android.util.Log;
import com.paydevice.smartpos.sdk.gpio.Gpio;
import com.paydevice.smartpos.sdk.serialport.SerialPort;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.Timer;
import java.util.TimerTask;

public class CashDrawer {
    private static final String TAG = "CashDrawer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIO(File file, String data) {
        if (file != null) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                fos.write(data.getBytes());
            }
            catch (NullPointerException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e2) {}
            }
        }
    }

    public static void open() {
        final File file = new File("/dev/cashbox_io");
        if (file.exists()) {
            CashDrawer.writeIO(file, "1");
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    CashDrawer.writeIO(file, "0");
                }
            };
            Timer timer = new Timer();
            timer.schedule(task, 1000L);
            Log.d((String)TAG, (String)"popup cashdrawer");
        } else {
            final int cashIO = SystemProperties.getInt((String)"hw.io.cashbox", (int)0);
            if (cashIO > 0) {
                Gpio.init(cashIO);
                Gpio.setMode(cashIO, 1);
                Gpio.setValue(cashIO, 1);
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        Gpio.setValue(cashIO, 0);
                    }
                };
                Timer timer = new Timer();
                timer.schedule(task, 1000L);
                Log.d((String)TAG, (String)"popup cashdrawer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openEx() {
        SerialPort sp = null;
        try {
            int i2;
            byte[] cmd = new byte[]{27, 112, 0};
            boolean found = false;
            for (i2 = 0; i2 < 10; ++i2) {
                File cb = new File("/dev/ttyCB" + i2);
                if (!cb.exists()) continue;
                found = true;
                break;
            }
            if (found) {
                sp = new SerialPort(new File("/dev/ttyCB" + i2), 9600);
                OutputStream mOutputStream = sp.getOutputStream();
                mOutputStream.write(new String(cmd).getBytes());
                Log.d((String)TAG, (String)"open Cash Drawer via USB-RJ11 converter");
            } else {
                Log.d((String)TAG, (String)"USB-RJ11 converter no found");
            }
        }
        catch (NullPointerException e2) {
            Log.d((String)TAG, (String)"USB-RJ11 converter fail:NullPointerException");
        }
        catch (SecurityException e3) {
            Log.d((String)TAG, (String)"USB-RJ11 converter fail:SecurityException");
        }
        catch (IOException e4) {
            Log.d((String)TAG, (String)"USB-RJ11 converter fail:IOException");
        }
        catch (InvalidParameterException e5) {
            Log.d((String)TAG, (String)"USB-RJ11 converter fail:InvalidParameterException");
        }
        finally {
            try {
                if (sp != null) {
                    sp.close();
                }
            }
            catch (Exception e2) {}
        }
    }
}

